/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.sharding.utils;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.mybatis.sharding.utils.NameUtils;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.TypeCreation;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.ibatis.annotations.Param;

public class ClassScanUtils {
    public static Class<?> generateMapperViaMapper(Class<?> clz, String dsName, boolean isShardingTable) {
        String name = NameUtils.buildClassName(dsName, clz.getCanonicalName());
        return ClassScanUtils.genInterfaceViaInterface(clz, name, isShardingTable);
    }

    private static Class<?> genInterfaceViaInterface(Class<?> clz, String name, boolean isShardingTable) {
        if (clz == null || !clz.isInterface()) {
            return null;
        }
        Annotation[] clzAnnos = clz.getAnnotations();
        Method[] methods = clz.getMethods();
        Field[] fields = clz.getDeclaredFields();
        DynamicType.Builder<?> builder = new ByteBuddy().makeInterface().name(name);
        for (Annotation anno : clzAnnos) {
            builder = builder.annotateType(new Annotation[]{anno});
        }
        for (Field f : fields) {
            try {
                builder = ClassScanUtils.genFields(builder, f);
            }
            catch (Exception e) {
                LogUtils.warn((String)"genInterfaceViaInterface - gen field failed:{}", (Object[])new Object[]{f.getName()});
            }
        }
        for (Method m : methods) {
            builder = ClassScanUtils.genBuilderMethod(builder, m, isShardingTable);
        }
        DynamicType.Unloaded unloaded = builder.make();
        ClassScanUtils.saveClass2Target(unloaded);
        return unloaded.load(clz.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded();
    }

    private static DynamicType.Builder<?> genFields(DynamicType.Builder<?> builder, final Field f) throws IllegalAccessException {
        if (f.getType().equals(Integer.TYPE)) {
            builder = builder.defineField(f.getName(), f.getType(), f.getModifiers()).value(((Integer)f.get(null)).intValue());
        } else if (f.getType() == Character.TYPE) {
            builder = builder.defineField(f.getName(), f.getType(), f.getModifiers()).value((int)((Character)f.get(null)).charValue());
        } else if (f.getType() == Short.TYPE) {
            builder = builder.defineField(f.getName(), f.getType(), f.getModifiers()).value((int)((Short)f.get(null)).shortValue());
        } else if (f.getType() == Byte.TYPE) {
            builder = builder.defineField(f.getName(), f.getType(), f.getModifiers()).value((int)((Byte)f.get(null)).byteValue());
        } else if (f.getType().equals(Long.TYPE)) {
            builder = builder.defineField(f.getName(), f.getType(), f.getModifiers()).value(((Long)f.get(null)).longValue());
        } else if (f.getType().equals(Float.TYPE)) {
            builder = builder.defineField(f.getName(), f.getType(), f.getModifiers()).value(((Float)f.get(null)).floatValue());
        } else if (f.getType().equals(Double.TYPE)) {
            builder = builder.defineField(f.getName(), f.getType(), f.getModifiers()).value(((Double)f.get(null)).doubleValue());
        } else if (f.getType().equals(String.class)) {
            builder = builder.defineField(f.getName(), f.getType(), f.getModifiers()).value(f.get(null).toString());
        } else {
            ByteCodeAppender initializer = new ByteCodeAppender(){

                public ByteCodeAppender.Size apply(MethodVisitor mv, Implementation.Context ctx, MethodDescription md) {
                    StackManipulation.Size size = null;
                    try {
                        size = new StackManipulation.Compound(new StackManipulation[]{TypeCreation.of((TypeDescription)new TypeDescription.ForLoadedType(f.getType())), Duplication.SINGLE, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(f.getType()).getDeclaredMethods().filter((ElementMatcher)ElementMatchers.isDefaultConstructor())).getOnly())), FieldAccess.forField((FieldDescription.InDefinedShape)((FieldDescription.InDefinedShape)((FieldList)ctx.getInstrumentedType().getDeclaredFields().filter((ElementMatcher)ElementMatchers.named((String)f.getName()))).getOnly())).write()}).apply(mv, ctx);
                    }
                    catch (Throwable t) {
                        LogUtils.warn((String)"field:{} is not defined precisely", (Object[])new Object[]{f.getName()});
                    }
                    if (size != null) {
                        return new ByteCodeAppender.Size(size.getMaximalSize(), md.getStackSize());
                    }
                    return new ByteCodeAppender.Size(0, 0);
                }
            };
            builder = builder.initializer(initializer);
            builder = builder.define(f);
        }
        return builder;
    }

    private static DynamicType.Builder<?> genBuilderMethod(DynamicType.Builder<?> builder, Method m, boolean isShardingTable) {
        Type[] types;
        Parameter[] params = m.getParameters();
        Type[] typeArray = types = isShardingTable ? new Type[m.getParameterCount() + 1] : new Type[m.getParameterCount()];
        if (isShardingTable) {
            types[0] = String.class;
        }
        int i = 0;
        for (Parameter p : params) {
            int idx = isShardingTable ? i + 1 : i;
            types[idx] = p.getType();
            ++i;
        }
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition methodBuilder = builder.defineMethod(m.getName(), m.getReturnType(), 1025).withParameters(types).withoutCode();
        if (isShardingTable) {
            methodBuilder = methodBuilder.annotateParameter(0, new AnnotationDescription[]{AnnotationDescription.Builder.ofType(Param.class).define("value", "tableName").build()});
        }
        int j = isShardingTable ? 1 : 0;
        for (Parameter p : params) {
            methodBuilder = methodBuilder.annotateParameter(j, p.getAnnotations());
            ++j;
        }
        return methodBuilder;
    }

    private static void saveClass2Target(DynamicType.Unloaded<?> unloaded) {
        String path = Thread.currentThread().getContextClassLoader().getResource("").getPath();
        path = path.substring(0, path.substring(0, path.length() - 1).lastIndexOf("/"));
        try {
            unloaded.saveIn(new File(path));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

