/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.sharding.utils;

import com.taotao.boot.data.mybatis.sharding.annos.Sharding;
import com.taotao.boot.data.mybatis.sharding.utils.Pair;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;
import org.springframework.util.SystemPropertyUtils;

public class ResourceUtil {
    private static final String[] SYSTEM_PATH = new String[]{"sun.", "java.", "javax.", "javafx.", "jdk.", "oracle.", "com.sun.", "com.oracle.", "netscape."};
    private static final Map<Class<?>, Sharding> SHARDING_MAP = new HashMap();

    private static boolean isSystemClass(String path) {
        for (String p : SYSTEM_PATH) {
            if (!path.startsWith(p)) continue;
            return true;
        }
        return false;
    }

    public static List<Class<?>> findClasses(String basePackage) {
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
        ArrayList candidates = new ArrayList();
        String packageSearchPath = "classpath*:" + ResourceUtil.resolveBasePackage(basePackage) + "/**/*.class";
        try {
            Resource[] resources;
            for (Resource resource : resources = resourcePatternResolver.getResources(packageSearchPath)) {
                MetadataReader metadataReader;
                String className;
                if (!resource.isReadable() || (className = (metadataReader = metadataReaderFactory.getMetadataReader(resource)).getClassMetadata().getClassName()).isEmpty() || className.contains("$") || ResourceUtil.isSystemClass(className)) continue;
                candidates.add(Class.forName(className));
            }
        }
        catch (IOException | ClassNotFoundException exception) {
            // empty catch block
        }
        return candidates;
    }

    public static Pair<List<Class<?>>, List<Class<?>>> getClassesWithAnno(String[] packages) {
        ArrayList shardingClasses = new ArrayList();
        ArrayList nonShardingClasses = new ArrayList();
        for (String pkg : packages) {
            List<Class<?>> cs = ResourceUtil.findClasses(pkg);
            block1: for (Class<?> clz : cs) {
                for (Annotation a : clz.getAnnotations()) {
                    if (!(a instanceof Sharding)) continue;
                    if (((Sharding)a).dbRule().isEmpty() && ((Sharding)a).tableRule().isEmpty()) {
                        nonShardingClasses.add(clz);
                        continue block1;
                    }
                    shardingClasses.add(clz);
                    continue block1;
                }
            }
        }
        return new Pair(nonShardingClasses, shardingClasses);
    }

    private static String resolveBasePackage(String basePackage) {
        return ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)basePackage));
    }

    public static Sharding getShardingAnno(Class<?> clz) {
        if (clz == null) {
            return null;
        }
        if (SHARDING_MAP.containsKey(clz)) {
            return SHARDING_MAP.get(clz);
        }
        for (Annotation a : clz.getAnnotations()) {
            if (!(a instanceof Sharding)) continue;
            SHARDING_MAP.putIfAbsent(clz, (Sharding)a);
            return (Sharding)a;
        }
        return null;
    }
}

