/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.sharding.utils;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.mybatis.sharding.utils.NameUtils;
import com.taotao.boot.data.mybatis.sharding.utils.Pair;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class XmlUtils {
    private static final SAXBuilder XML_BUILDER = new SAXBuilder();

    public static Pair<String, Resource> changeMapperNameSpace(String dsName, Resource resource) {
        InputStream inputStream = null;
        try {
            inputStream = resource.getInputStream();
        }
        catch (IOException e) {
            LogUtils.warn((String)"changeMapperNameSpace - exception occurred", (Object[])new Object[]{e});
        }
        if (inputStream == null) {
            return null;
        }
        Document doc = null;
        try {
            doc = XML_BUILDER.build(inputStream);
        }
        catch (IOException | JDOMException e) {
            LogUtils.warn((String)"changeMapperNameSpace - error in mapper", (Object[])new Object[0]);
            return null;
        }
        Element element = doc.getRootElement();
        String originalName = element.getAttribute("namespace").getValue();
        if (originalName == null || originalName.isEmpty()) {
            return null;
        }
        String name = NameUtils.buildClassName(dsName, originalName);
        element.setAttribute("namespace", name);
        doc.detachRootElement();
        doc.setRootElement(element);
        Format format = Format.getPrettyFormat();
        format.setEncoding("UTF-8");
        format.setTextMode(Format.TextMode.PRESERVE);
        XMLOutputter output = new XMLOutputter(format);
        String xml = output.outputString(doc);
        InputStreamResource res = new InputStreamResource((InputStream)new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)), name);
        return Pair.of(name, res);
    }

    public static String extractNamespace(Resource resource) {
        InputStream inputStream = null;
        try {
            inputStream = resource.getInputStream();
        }
        catch (IOException e) {
            LogUtils.warn((String)"changeMapperNameSpace - exception occurred", (Object[])new Object[]{e});
        }
        if (inputStream == null) {
            return null;
        }
        Document doc = null;
        try {
            doc = XML_BUILDER.build(inputStream);
        }
        catch (IOException | JDOMException e) {
            LogUtils.warn((String)"changeMapperNameSpace - error in mapper", (Object[])new Object[0]);
            return null;
        }
        Element element = doc.getRootElement();
        return element.getAttribute("namespace").getValue();
    }
}

