/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.templateParser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.mybatis.templateParser.SpFieldHandler;
import org.apache.ibatis.parsing.TokenHandler;

public class JsonTokenHandler
implements TokenHandler {
    private final ObjectMapper objectMapper;
    private JsonNode jsonNode;
    private final SpFieldHandler<JsonNode> spFieldHandler;

    public JsonTokenHandler(String json, SpFieldHandler<JsonNode> spFieldHandler) {
        this.spFieldHandler = spFieldHandler;
        this.objectMapper = new ObjectMapper();
        try {
            this.jsonNode = this.objectMapper.readTree(json);
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
        }
    }

    public String handleToken(String content) {
        String value = "'-'";
        if (this.jsonNode != null) {
            String[] fieldPath = content.split("\\.");
            JsonNode currentNode = this.jsonNode;
            for (String fieldName : fieldPath) {
                if (currentNode.isObject()) {
                    currentNode = currentNode.get(fieldName);
                } else {
                    try {
                        JsonNode jsonValue = this.objectMapper.readTree(currentNode.asText());
                        if (jsonValue == null || !jsonValue.isObject()) break;
                        currentNode = jsonValue.get(fieldName);
                    }
                    catch (Exception e) {
                        break;
                    }
                }
                if (currentNode == null) break;
            }
            value = this.spFieldHandler.parseSpFieldValue(content, currentNode);
        }
        return "null".equals(value) ? "'-'" : value;
    }
}

