/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.utils;

import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.google.common.collect.Lists;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.datasource.tx.TransactionalUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class BatchUtils {
    private final TransactionalUtils transactionalUtils;
    private final ThreadPoolTaskExecutor taskExecutor;
    private static final int DEFAULT_BATCH_NUM = 1000;

    public BatchUtils(TransactionalUtils transactionalUtils, ThreadPoolTaskExecutor taskExecutor) {
        this.transactionalUtils = transactionalUtils;
        this.taskExecutor = taskExecutor;
    }

    public <T> void insertBatch(List<T> dataList, Consumer<List<T>> batchOps) {
        this.insertBatch(dataList, 1000, batchOps, "master");
    }

    public <T> void insertBatch(List<T> dataList, Consumer<List<T>> batchOps, String ds) {
        this.insertBatch(dataList, 1000, batchOps, ds);
    }

    public <T> void insertBatch(List<T> dataList, int batchNum, Consumer<List<T>> batchOps, String ds) {
        List partition = Lists.partition(dataList, (int)batchNum);
        AtomicBoolean rollback = new AtomicBoolean(false);
        CyclicBarrier cyclicBarrier = new CyclicBarrier(partition.size());
        List<CompletableFuture> futures = partition.parallelStream().map(item -> CompletableFuture.runAsync(() -> this.handleBatch((List)item, batchOps, cyclicBarrier, rollback, ds), (Executor)this.taskExecutor)).toList();
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        if (rollback.get()) {
            throw new RuntimeException("\u6279\u91cf\u63d2\u5165\u6570\u636e\u5f02\u5e38\uff0c\u6570\u636e\u5df2\u56de\u6eda");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void handleBatch(List<T> item, Consumer<List<T>> batchOps, CyclicBarrier cyclicBarrier, AtomicBoolean rollback, String ds) {
        try {
            DynamicDataSourceContextHolder.push((String)ds);
            this.transactionalUtils.executeWithoutResult(callback -> {
                try {
                    batchOps.accept(item);
                    cyclicBarrier.await(60L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    this.handleException(cyclicBarrier, rollback, e.getMessage());
                }
                finally {
                    if (rollback.get()) {
                        callback.setRollbackOnly();
                    }
                }
            });
        }
        finally {
            DynamicDataSourceContextHolder.clear();
        }
    }

    private void handleException(CyclicBarrier cyclicBarrier, AtomicBoolean rollback, String msg) {
        rollback.compareAndSet(false, true);
        LogUtils.error((String)"\u6279\u91cf\u63d2\u5165\u6570\u636e\u5f02\u5e38\uff0c\u5df2\u8bbe\u7f6e\u56de\u6eda\u6807\u8bc6\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object[])new Object[]{msg});
        cyclicBarrier.reset();
    }
}

