/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.utils;

import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.google.common.collect.Lists;
import com.taotao.boot.common.utils.log.LogUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.apache.ibatis.datasource.DataSourceException;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.dromara.hutool.core.util.ObjUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class MybatisUtil {
    private final Executor executor;
    private final SqlSessionFactory sqlSessionFactory;
    private static final int DEFAULT_BATCH_NUM = 50000;

    public MybatisUtil(@Autowired @Qualifier(value="asyncThreadPoolTaskExecutor") Executor executor, SqlSessionFactory sqlSessionFactory) {
        this.executor = executor;
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public <T, M> void batch(List<T> dataList, Class<M> clazz, BiConsumer<M, T> consumer) {
        this.batch(dataList, 50000, clazz, "master", consumer);
    }

    public <T, M> void batch(List<T> dataList, Class<M> clazz, String ds, BiConsumer<M, T> consumer) {
        this.batch(dataList, 50000, clazz, ds, consumer);
    }

    public <T, M> void batch(List<T> dataList, int batchNum, Class<M> clazz, String ds, BiConsumer<M, T> consumer) {
        List partition = Lists.partition(dataList, (int)batchNum);
        AtomicBoolean rollback = new AtomicBoolean(false);
        int size = partition.size();
        CyclicBarrier cyclicBarrier = size > 10 ? null : new CyclicBarrier(partition.size());
        List<CompletableFuture> futures = partition.stream().map(item -> CompletableFuture.runAsync(() -> this.handleBatch((List)item, clazz, consumer, rollback, ds, cyclicBarrier), this.executor)).toList();
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        if (rollback.get()) {
            throw new DataSourceException("\u6279\u91cf\u63d2\u5165\u6570\u636e\u5f02\u5e38\uff0c\u6570\u636e\u5df2\u56de\u6eda");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, M> void handleBatch(List<T> item, Class<M> clazz, BiConsumer<M, T> consumer, AtomicBoolean rollback, String ds, CyclicBarrier cyclicBarrier) {
        try {
            DynamicDataSourceContextHolder.push((String)ds);
            SqlSession sqlSession = this.sqlSessionFactory.openSession(ExecutorType.BATCH, false);
            Object mapper = sqlSession.getMapper(clazz);
            try {
                item.forEach(i -> consumer.accept(mapper, i));
                if (ObjUtil.isNotNull((Object)cyclicBarrier)) {
                    cyclicBarrier.await(180L, TimeUnit.SECONDS);
                }
                sqlSession.commit();
            }
            catch (Exception e) {
                this.handleException(rollback, e, cyclicBarrier);
            }
            finally {
                if (rollback.get()) {
                    sqlSession.rollback();
                }
                sqlSession.clearCache();
                sqlSession.close();
            }
        }
        finally {
            DynamicDataSourceContextHolder.clear();
        }
    }

    private void handleException(AtomicBoolean rollback, Exception e, CyclicBarrier cyclicBarrier) {
        rollback.compareAndSet(false, true);
        LogUtils.error((String)"\u6279\u91cf\u63d2\u5165\u6570\u636e\u5f02\u5e38\uff0c\u5df2\u8bbe\u7f6e\u56de\u6eda\u6807\u8bc6\uff0c\u9519\u8bef\u4fe1\u606f", (Object[])new Object[]{e});
        if (ObjUtil.isNotNull((Object)cyclicBarrier)) {
            cyclicBarrier.reset();
        }
    }
}

