/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.p6spy.logger;

import com.p6spy.engine.logging.Category;
import com.p6spy.engine.spy.P6SpyOptions;
import com.p6spy.engine.spy.appender.BatchFileLogger;
import com.taotao.boot.common.utils.context.ContextUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.springframework.context.ConfigurableApplicationContext;

public class FileLogger
extends BatchFileLogger {
    private String fileName = null;
    private volatile PrintStream printStream = null;

    private void init() {
        if (this.fileName == null) {
            throw new IllegalStateException("setLogfile() must be called before init()");
        }
        ConfigurableApplicationContext applicationContext = ContextUtils.getApplicationContext();
        String realFileName = applicationContext.getEnvironment().resolvePlaceholders(this.fileName);
        try {
            File file = new File(realFileName);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            this.printStream = new PrintStream(new FileOutputStream(file, P6SpyOptions.getActiveInstance().getAppend()));
        }
        catch (IOException e) {
            throw new IllegalStateException("couldn't create PrintStream for " + this.fileName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PrintStream getStream() {
        if (this.printStream == null) {
            FileLogger fileLogger = this;
            synchronized (fileLogger) {
                if (this.printStream == null) {
                    this.init();
                }
            }
        }
        return this.printStream;
    }

    public void setLogfile(String fileName) {
        this.fileName = fileName;
    }

    public void logSQL(int connectionId, String now, long elapsed, Category category, String prepared, String sql, String url) {
        super.logSQL(connectionId, now, elapsed, category, prepared, sql, url);
    }
}

