/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.ddd.domain.handler;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.ddd.domain.support.DomainEventPublisher;
import com.taotao.boot.ddd.domain.support.TraceHandler;
import com.taotao.boot.ddd.model.domain.event.DefaultDomainEvent;
import java.nio.charset.StandardCharsets;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.spring.core.RocketMQListener;

public abstract class AbstractDomainEventHandler
extends TraceHandler
implements RocketMQListener<MessageExt> {
    protected final DomainEventPublisher rocketMQDomainEventPublisher;

    protected AbstractDomainEventHandler(DomainEventPublisher rocketMQDomainEventPublisher) {
        this.rocketMQDomainEventPublisher = rocketMQDomainEventPublisher;
    }

    public void onMessage(MessageExt messageExt) {
        try {
            this.putTrace(messageExt);
            String msg = new String(messageExt.getBody(), StandardCharsets.UTF_8);
            this.handleDomainEvent(this.convert(msg));
        }
        catch (Exception e) {
            LogUtils.error((String)"\u6d88\u8d39\u5931\u8d25\uff0c\u4e3b\u9898Topic\uff1a{}\uff0c\u504f\u79fb\u91cfOffset\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object[])new Object[]{messageExt.getTopic(), messageExt.getCommitLogOffset(), e.getMessage(), e});
            throw e;
        }
        finally {
            this.clearTrace();
        }
    }

    protected abstract void handleDomainEvent(DefaultDomainEvent var1);

    protected abstract DefaultDomainEvent convert(String var1);
}

