/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.ddd.domain.handler;

import com.taotao.boot.ddd.domain.model.DomainEventA;
import com.taotao.boot.ddd.domain.service.DomainEventService;
import com.taotao.boot.ddd.domain.support.AbstractTransactionHandler;
import com.taotao.boot.ddd.model.domain.event.DefaultDomainEvent;
import org.apache.rocketmq.spring.annotation.RocketMQTransactionListener;
import org.dromara.hutool.core.bean.BeanUtil;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
@RocketMQTransactionListener(corePoolSize=16, maximumPoolSize=32)
public class DomainEventTransactionHandler
extends AbstractTransactionHandler {
    private final DomainEventService domainEventService;

    public DomainEventTransactionHandler(DomainEventService domainEventService) {
        this.domainEventService = domainEventService;
    }

    @Override
    protected void executeExtLocalTransaction(Message message, Object args) {
        byte[] payload = (byte[])message.getPayload();
        this.domainEventService.create(new DomainEventA(payload, (DefaultDomainEvent)BeanUtil.toBean((Object)payload, DefaultDomainEvent.class)));
    }

    @Override
    protected boolean checkExtLocalTransaction(Message message) {
        Object obj = message.getHeaders().get((Object)"TRANSACTION_ID");
        Assert.notNull((Object)obj, (String)"\u4e8b\u52a1ID\u4e0d\u4e3a\u7a7a");
        return this.domainEventService.countById(Long.parseLong(obj.toString())) > 0L;
    }
}

