/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.ddd.domain.handler;

import com.taotao.boot.common.utils.lang.ObjectUtils;
import com.taotao.boot.ddd.domain.handler.AbstractDomainEventHandler;
import com.taotao.boot.ddd.domain.handler.domainevent.RemoveCacheEvent;
import com.taotao.boot.ddd.domain.support.DomainEventPublisher;
import com.taotao.boot.ddd.model.domain.event.DefaultDomainEvent;
import java.util.List;
import org.dromara.hutool.core.bean.BeanUtil;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Component;

@Component
public class RemoveCacheEventHandler
extends AbstractDomainEventHandler {
    private final List<CacheManager> cacheManagers;

    public RemoveCacheEventHandler(DomainEventPublisher rocketMQDomainEventPublisher, List<CacheManager> cacheManagers) {
        super(rocketMQDomainEventPublisher);
        this.cacheManagers = cacheManagers;
    }

    @Override
    protected void handleDomainEvent(DefaultDomainEvent domainEvent) {
        RemoveCacheEvent event = (RemoveCacheEvent)domainEvent;
        this.cacheManagers.forEach(item -> {
            Cache cache = item.getCache(event.getName());
            if (ObjectUtils.isNotNull((Object)cache)) {
                cache.evictIfPresent((Object)event.getKey());
            }
        });
    }

    @Override
    protected DefaultDomainEvent convert(String msg) {
        return (DefaultDomainEvent)BeanUtil.toBean((Object)msg, RemoveCacheEvent.class);
    }
}

