/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.ddd.domain.service.impl;

import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.taotao.boot.data.datasource.tx.TransactionalUtils;
import com.taotao.boot.ddd.domain.convertor.DomainEventConvertor;
import com.taotao.boot.ddd.domain.entity.DomainEventDO;
import com.taotao.boot.ddd.domain.mapper.DomainEventMapper;
import com.taotao.boot.ddd.domain.model.DomainEventA;
import com.taotao.boot.ddd.domain.service.DomainEventService;
import org.springframework.stereotype.Service;

@Service
public class DomainEventServiceImpl
implements DomainEventService {
    private static final String DOMAIN = "domain";
    private final DomainEventMapper domainEventMapper;
    private final TransactionalUtils transactionalUtils;

    public DomainEventServiceImpl(DomainEventMapper domainEventMapper, TransactionalUtils transactionalUtils) {
        this.domainEventMapper = domainEventMapper;
        this.transactionalUtils = transactionalUtils;
    }

    @Override
    public void create(DomainEventA domainEventA) {
        try {
            DynamicDataSourceContextHolder.push((String)DOMAIN);
            this.transactionalUtils.defaultExecuteWithoutResult(r -> {
                try {
                    DomainEventDO eventDO = DomainEventConvertor.toDataObject(domainEventA);
                    this.domainEventMapper.insert(eventDO);
                }
                catch (Exception e) {
                    r.setRollbackOnly();
                }
            });
        }
        finally {
            DynamicDataSourceContextHolder.clear();
        }
    }

    @Override
    public Long countById(Long id) {
        try {
            DynamicDataSourceContextHolder.push((String)DOMAIN);
            Long l = 0L;
            return l;
        }
        finally {
            DynamicDataSourceContextHolder.clear();
        }
    }

    @Override
    public void deleteOldByServiceIdOfThreeMonths(String serviceId) {
        try {
            DynamicDataSourceContextHolder.push((String)DOMAIN);
            this.transactionalUtils.defaultExecuteWithoutResult(r -> {
                try {
                    this.domainEventMapper.deleteOldByServiceIdOfThreeMonths(serviceId);
                }
                catch (Exception e) {
                    r.setRollbackOnly();
                }
            });
        }
        finally {
            DynamicDataSourceContextHolder.clear();
        }
    }
}

