/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.ddd.model.application.assembler;

import com.taotao.boot.ddd.model.domain.ValueObjectEnum;
import java.beans.PropertyDescriptor;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;

public class BaseAssembler {
    private BaseAssembler() {
    }

    public static <T, R> R convert(T source, Class<R> targetClass) {
        R target = null;
        try {
            target = targetClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        BeanUtils.copyProperties(source, target);
        BaseAssembler.copyVoEnumValue(source, target);
        return target;
    }

    public static <T, R> R copyVoEnumValue(T source, R target) {
        BeanWrapperImpl sourceWrapper = new BeanWrapperImpl(source);
        BeanWrapperImpl targetWrapper = new BeanWrapperImpl(target);
        PropertyDescriptor[] sourcePropertyDescriptors = sourceWrapper.getPropertyDescriptors();
        PropertyDescriptor[] targetPropertyDescriptors = targetWrapper.getPropertyDescriptors();
        for (PropertyDescriptor sourcePropDesc : sourcePropertyDescriptors) {
            String sourcePropName;
            ValueObjectEnum sourcePropVoEnumVal;
            PropertyDescriptor targetPropDesc = BaseAssembler.matchVoEnumTypeAndPropName(sourcePropDesc, targetPropertyDescriptors);
            if (Objects.isNull(targetPropDesc) || Objects.isNull(sourcePropVoEnumVal = (ValueObjectEnum)sourceWrapper.getPropertyValue(sourcePropName = sourcePropDesc.getName()))) continue;
            targetWrapper.setPropertyValue(sourcePropName, sourcePropVoEnumVal.getValue());
        }
        return target;
    }

    private static PropertyDescriptor matchVoEnumTypeAndPropName(PropertyDescriptor sourcePropDesc, PropertyDescriptor[] targetPropDescs) {
        boolean sourcePropIsVoEnum = ValueObjectEnum.class.isAssignableFrom(sourcePropDesc.getPropertyType());
        if (!sourcePropIsVoEnum) {
            return null;
        }
        String sourcePropName = sourcePropDesc.getName();
        for (PropertyDescriptor targetPropDesc : targetPropDescs) {
            if (!targetPropDesc.getName().equals(sourcePropName) || sourcePropDesc.getPropertyType().equals(targetPropDesc.getPropertyType())) continue;
            return targetPropDesc;
        }
        return null;
    }
}

