/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.ddd.model.application.dto;

import com.taotao.boot.ddd.model.application.dto.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MultiResponse<T>
extends Response {
    private static final long serialVersionUID = 1L;
    private Collection<T> data;

    public List<T> getData() {
        if (null == this.data) {
            return Collections.emptyList();
        }
        if (this.data instanceof List) {
            return (List)this.data;
        }
        return new ArrayList<T>(this.data);
    }

    public void setData(Collection<T> data) {
        this.data = data;
    }

    public boolean isEmpty() {
        return this.data == null || this.data.isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public static MultiResponse buildSuccess() {
        MultiResponse response = new MultiResponse();
        response.setSuccess(true);
        return response;
    }

    public static MultiResponse buildFailure(String errCode, String errMessage) {
        MultiResponse response = new MultiResponse();
        response.setSuccess(false);
        response.setErrCode(errCode);
        response.setErrMessage(errMessage);
        return response;
    }

    public static <T> MultiResponse<T> of(Collection<T> data) {
        MultiResponse<T> response = new MultiResponse<T>();
        response.setSuccess(true);
        response.setData(data);
        return response;
    }

    @Override
    public String toString() {
        return "MultiResponse{success=" + super.isSuccess() + ", data=" + String.valueOf(this.data) + ", errCode='" + super.getErrCode() + "', errMessage='" + super.getErrMessage() + "'}";
    }
}

