/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.ddd.model.infrastructure;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.taotao.boot.ddd.model.application.dto.PageQuery;
import com.taotao.boot.ddd.model.application.dto.PageResponse;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.StringUtils;

public interface JpaPageConvertor {
    public static Pageable toPage(PageQuery pageQuery) {
        PageRequest pageRequest = PageRequest.of((int)Math.max(pageQuery.getPageIndex() - 1, 0), (int)pageQuery.getPageSize());
        if (StringUtils.hasText((String)pageQuery.getOrderBy())) {
            Sort sort = "ASC".equals(pageQuery.getOrderDirection()) ? Sort.by((String[])new String[]{pageQuery.getOrderBy()}).ascending() : Sort.by((String[])new String[]{pageQuery.getOrderBy()}).descending();
            pageRequest = pageRequest.withSort(sort);
        }
        return pageRequest;
    }

    public static <T> PageResponse<T> toPageResponse(Page<T> pageResult) {
        return PageResponse.of(pageResult.getContent(), Long.valueOf(pageResult.getTotalElements()).intValue(), pageResult.getPageable().getPageSize(), pageResult.getPageable().getPageNumber() + 1);
    }

    public static <T, R> PageResponse<R> toPageResponse(Page<T> pageResult, Function<T, R> convertor) {
        List resultList = Collections.emptyList();
        if (CollectionUtils.isNotEmpty((Collection)pageResult.getContent())) {
            resultList = pageResult.getContent().stream().map(convertor).collect(Collectors.toList());
        }
        return PageResponse.of(resultList, Long.valueOf(pageResult.getTotalElements()).intValue(), pageResult.getPageable().getPageSize(), pageResult.getPageable().getPageNumber() + 1);
    }
}

