/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.ddd.model.infrastructure;

import com.taotao.boot.ddd.model.domain.ValueObjectEnum;
import com.taotao.boot.ddd.model.exception.SysException;
import jakarta.persistence.AttributeConverter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;

public abstract class JpaVoEnumAttrConverter<T extends ValueObjectEnum<D>, D>
implements AttributeConverter<T, D> {
    protected Class<T> voEnumClass;

    protected JpaVoEnumAttrConverter() {
        Type genType = this.getClass().getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            throw new SysException("BaseJpaVoEnumAttrConverter init Exception - ", genType.getTypeName());
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        this.voEnumClass = (Class)params[0];
    }

    public D convertToDatabaseColumn(T attribute) {
        return Optional.ofNullable(attribute).map(ValueObjectEnum::getValue).orElse(null);
    }

    public T convertToEntityAttribute(D dbData) {
        return ValueObjectEnum.of(dbData, this.voEnumClass);
    }
}

