/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.ddd.model.infrastructure;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.taotao.boot.ddd.model.application.dto.PageQuery;
import com.taotao.boot.ddd.model.application.dto.PageResponse;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface MpPageConvertor {
    public static Page toPage(PageQuery pageQuery) {
        Integer pageSize = 0 < pageQuery.getPageSize() ? pageQuery.getPageSize() : -1;
        Page page = Page.of((long)pageQuery.getPageIndex(), (long)pageSize.intValue());
        if (StringUtils.isNotBlank((CharSequence)pageQuery.getOrderBy())) {
            OrderItem orderItem = "ASC".equals(pageQuery.getOrderDirection()) ? OrderItem.asc((String)pageQuery.getOrderBy()) : OrderItem.desc((String)pageQuery.getOrderBy());
            page.addOrder(new OrderItem[]{orderItem});
        }
        return page;
    }

    public static <T> PageResponse<T> toPageResponse(IPage<T> pageResult) {
        return PageResponse.of(pageResult.getRecords(), Long.valueOf(pageResult.getTotal()).intValue(), Long.valueOf(pageResult.getCurrent()).intValue(), Long.valueOf(pageResult.getSize()).intValue());
    }

    public static <T, R> PageResponse<R> toPageResponse(IPage<T> pageResult, Function<T, R> convertor) {
        List resultList = Collections.emptyList();
        if (CollectionUtils.isNotEmpty((Collection)pageResult.getRecords())) {
            resultList = pageResult.getRecords().stream().map(convertor).collect(Collectors.toList());
        }
        return PageResponse.of(resultList, Long.valueOf(pageResult.getTotal()).intValue(), Long.valueOf(pageResult.getCurrent()).intValue(), Long.valueOf(pageResult.getSize()).intValue());
    }
}

