/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.ddd.model.infrastructure;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.taotao.boot.ddd.model.application.dto.PageQuery;
import com.taotao.boot.ddd.model.application.dto.PageResponse;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface PageHelperConvertor {
    public static void startPage(PageQuery pageQuery) {
        String orderBy = Stream.of(pageQuery.getOrderBy(), pageQuery.getOrderBy()).filter(Objects::nonNull).collect(Collectors.joining(" "));
        PageHelper.startPage((int)pageQuery.getPageIndex(), (int)pageQuery.getPageSize(), (String)orderBy);
    }

    public static <T> PageResponse<T> toPageResponse(PageInfo<T> pageInfo) {
        return PageResponse.of(pageInfo.getList(), Long.valueOf(pageInfo.getTotal()).intValue(), pageInfo.getPageSize(), pageInfo.getPageNum());
    }

    public static <T> PageResponse<T> toPageResponse(List<T> listResult) {
        return PageHelperConvertor.toPageResponse(PageInfo.of(listResult));
    }

    public static <T, R> PageResponse<R> toPageResponse(PageInfo<T> pageInfo, Function<T, R> convertor) {
        List resultList = Collections.emptyList();
        if (null != pageInfo.getList() && !pageInfo.getList().isEmpty()) {
            resultList = pageInfo.getList().stream().map(convertor).collect(Collectors.toList());
        }
        return PageResponse.of(resultList, Long.valueOf(pageInfo.getTotal()).intValue(), pageInfo.getPageSize(), pageInfo.getPageNum());
    }

    public static <T, R> PageResponse<R> toPageResponse(List<T> listResult, Function<T, R> convertor) {
        return PageHelperConvertor.toPageResponse(PageInfo.of(listResult), convertor);
    }
}

