/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.ddd.model.types;

import com.taotao.boot.ddd.model.domain.Identifier;
import com.taotao.boot.ddd.util.validation.Validates;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Positive;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.dromara.hutool.core.data.id.IdUtil;

public class BizId
extends Identifier<Long> {
    @NotNull
    @Positive
    private Long id;

    BizId() {
    }

    BizId(Long id) {
        this.id = id;
        this.validateSelf();
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public static BizId newBizId() {
        return new BizId(IdUtil.getSnowflakeNextId());
    }

    public static Set<Long> toValues(Collection<BizId> bizIds) {
        Validates.notEmpty(bizIds, "BizId list is empty");
        return bizIds.stream().map(BizId::getId).collect(Collectors.toSet());
    }

    public static BizId fromValue(Long id) {
        return new BizId(id);
    }

    public static Set<BizId> fromValues(Collection<Long> values) {
        Validates.notEmpty(values, "BizId value list is empty");
        return values.stream().map(BizId::new).collect(Collectors.toSet());
    }

    public static Set<BizId> fromNullableValues(Collection<Long> values) {
        if (Objects.isNull(values) || values.isEmpty()) {
            return new HashSet<BizId>();
        }
        return values.stream().map(BizId::new).collect(Collectors.toSet());
    }

    public String toString() {
        return String.valueOf(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BizId bizId = (BizId)o;
        return Objects.equals(this.id, bizId.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

