/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.ddd.util.validation;

import com.taotao.boot.ddd.model.exception.ValidateException;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Validates {
    private static final String DOT = ".";
    private static final String SEPARATOR_COLON = ": ";
    private static final String SEPARATOR_COMMA = ", ";
    private static Validator validator;
    public static BiFunction<String, String, RuntimeException> errorToExceptionFunc;
    private static final ThreadLocal<RuntimeException> validationExceptionHolder;

    public static <T> void validateEntity(T object, Class<?> ... groups) {
        Set constraintViolations = validator.validate(object, (Class[])groups);
        RuntimeException validationException = Validates.getValidationException(true);
        if (Objects.nonNull(validationException)) {
            throw validationException;
        }
        if (null == constraintViolations || constraintViolations.isEmpty()) {
            return;
        }
        throw errorToExceptionFunc.apply(null, Validates.convertConstraintViolations(constraintViolations));
    }

    public static void setValidationException(RuntimeException validationException) {
        validationExceptionHolder.set(validationException);
    }

    public static RuntimeException getValidationException(Boolean removeException) {
        RuntimeException validationException = validationExceptionHolder.get();
        if (Objects.nonNull(validationException) && Boolean.TRUE.equals(removeException)) {
            validationExceptionHolder.remove();
        }
        return validationException;
    }

    public static void setValidator(Validator validator) {
        Validates.validator = validator;
    }

    public static <T> String convertConstraintViolations(Set<ConstraintViolation<T>> constraintViolations) {
        if (null == constraintViolations || constraintViolations.isEmpty()) {
            return null;
        }
        return constraintViolations.stream().map(Validates::convertConstrainViolation).collect(Collectors.joining(SEPARATOR_COMMA));
    }

    public static <T> String convertConstraintViolationsUnknownType(Set<ConstraintViolation<?>> constraintViolations) {
        if (null == constraintViolations || constraintViolations.isEmpty()) {
            return null;
        }
        return constraintViolations.stream().map(Validates::convertConstrainViolation).collect(Collectors.joining(SEPARATOR_COMMA));
    }

    public static String convertConstrainViolation(ConstraintViolation<?> constraintViolation) {
        String rootBeanName = constraintViolation.getRootBeanClass().getSimpleName();
        String path = constraintViolation.getPropertyPath().toString();
        String errMsg = constraintViolation.getMessage();
        return String.format("%s.%s:%s", rootBeanName, path, errMsg);
    }

    public static void isTrue(boolean expression, String errCode, String errMessage) {
        if (!Boolean.TRUE.equals(expression)) {
            throw errorToExceptionFunc.apply(errCode, errMessage);
        }
    }

    public static void isTrue(boolean expression, String errMessage) {
        Validates.isTrue(expression, null, errMessage);
    }

    public static void isTrue(boolean expression) {
        Validates.isTrue(expression, "[Assertion failed] Must be true");
    }

    public static void isFalse(boolean expression, String errCode, String errMessage) {
        if (!Boolean.FALSE.equals(expression)) {
            throw errorToExceptionFunc.apply(errCode, errMessage);
        }
    }

    public static void isFalse(boolean expression, String errMessage) {
        Validates.isFalse(expression, null, errMessage);
    }

    public static void isFalse(boolean expression) {
        Validates.isFalse(expression, "[Assertion failed] Must be false");
    }

    public static void notNull(Object object, String errCode, String errMessage) {
        if (object == null) {
            throw errorToExceptionFunc.apply(errCode, errMessage);
        }
    }

    public static void notNull(Object object, String errMessage) {
        Validates.notNull(object, null, errMessage);
    }

    public static void notNull(Object object) {
        Validates.notNull(object, "[Assertion failed] Must not null");
    }

    public static void notBlank(String str, String errCode, String errMessage) {
        if (str == null || str.trim().length() <= 0) {
            throw errorToExceptionFunc.apply(errCode, errMessage);
        }
    }

    public static void notBlank(String str, String errMessage) {
        Validates.notBlank(str, null, errMessage);
    }

    public static void notBlank(String str) {
        Validates.notBlank(str, "[Assertion failed] Must not blank");
    }

    public static void notEmpty(String str, String errCode, String errMessage) {
        if (str == null || str.isEmpty()) {
            throw errorToExceptionFunc.apply(errCode, errMessage);
        }
    }

    public static void notEmpty(String str, String errMessage) {
        Validates.notEmpty(str, null, errMessage);
    }

    public static void notEmpty(String str) {
        Validates.notEmpty(str, "[Assertion failed] Must not empty");
    }

    public static void notEmpty(Collection<?> collection, String errCode, String errMessage) {
        if (collection == null || collection.isEmpty()) {
            throw errorToExceptionFunc.apply(errCode, errMessage);
        }
    }

    public static void notEmpty(Collection<?> collection, String errMessage) {
        Validates.notEmpty(collection, null, errMessage);
    }

    public static void notEmpty(Collection<?> collection) {
        Validates.notEmpty(collection, "[Assertion failed] Collection must not be empty: it must contain at least 1 element");
    }

    public static void notEmpty(Map<?, ?> map, String errCode, String errMessage) {
        if (map == null || map.isEmpty()) {
            throw errorToExceptionFunc.apply(errCode, errMessage);
        }
    }

    public static void notEmpty(Map<?, ?> map, String errMessage) {
        Validates.notEmpty(map, null, errMessage);
    }

    public static void notEmpty(Map<?, ?> map) {
        Validates.notEmpty(map, "[Assertion failed] Map must not be empty: it must contain at least one entry");
    }

    public static void range(Short num, Short min, Short max, String errCode, String errMessage) {
        Boolean notInRange = null != num && (num < min || num > max);
        if (notInRange.booleanValue()) {
            throw errorToExceptionFunc.apply(errCode, errMessage);
        }
    }

    public static void range(Short num, Short min, Short max, String errMessage) {
        Validates.range(num, min, max, null, errMessage);
    }

    public static void range(Short num, Short min, Short max) {
        Validates.range(num, min, max, "[Assertion failed] Must not exceed range");
    }

    public static void min(Short num, Short min, String errCode, String errMessage) {
        if (null != num && num < min) {
            throw errorToExceptionFunc.apply(errCode, errMessage);
        }
    }

    public static void min(Short num, Short min, String errMessage) {
        Validates.min(num, min, null, errMessage);
    }

    public static void min(Short num, Short min) {
        Validates.min(num, min, "[Assertion failed] Must not less than min");
    }

    public static void max(Short num, Short max, String errCode, String errMessage) {
        if (null != num && num > max) {
            throw errorToExceptionFunc.apply(errCode, errMessage);
        }
    }

    public static void max(Short num, Short max, String errMessage) {
        Validates.max(num, max, null, errMessage);
    }

    public static void max(Short num, Short max) {
        Validates.max(num, max, "[Assertion failed] Must not greater than max");
    }

    public static void range(Integer num, Integer min, Integer max, String errCode, String errMessage) {
        Boolean notInRange = null != num && (num < min || num > max);
        if (notInRange.booleanValue()) {
            throw errorToExceptionFunc.apply(errCode, errMessage);
        }
    }

    public static void range(Integer num, Integer min, Integer max, String errMessage) {
        Validates.range(num, min, max, null, errMessage);
    }

    public static void range(Integer num, Integer min, Integer max) {
        Validates.range(num, min, max, "[Assertion failed] Must not exceed range");
    }

    public static void min(Integer num, Integer min, String errCode, String errMessage) {
        if (null != num && num < min) {
            throw errorToExceptionFunc.apply(errCode, errMessage);
        }
    }

    public static void min(Integer num, Integer min, String errMessage) {
        Validates.min(num, min, null, errMessage);
    }

    public static void min(Integer num, Integer min) {
        Validates.min(num, min, "[Assertion failed] Must not less than min");
    }

    public static void max(Integer num, Integer max, String errCode, String errMessage) {
        if (null != num && num > max) {
            throw errorToExceptionFunc.apply(errCode, errMessage);
        }
    }

    public static void max(Integer num, Integer max, String errMessage) {
        Validates.max(num, max, null, errMessage);
    }

    public static void max(Integer num, Integer max) {
        Validates.max(num, max, "[Assertion failed] Must not greater than max");
    }

    public static void range(Long num, Long min, Long max, String errCode, String errMessage) {
        Boolean notInRange = null != num && (num < min || num > max);
        if (notInRange.booleanValue()) {
            throw errorToExceptionFunc.apply(errCode, errMessage);
        }
    }

    public static void range(Long num, Long min, Long max, String errMessage) {
        Validates.range(num, min, max, null, errMessage);
    }

    public static void range(Long num, Long min, Long max) {
        Validates.range(num, min, max, "[Assertion failed] Must not exceed range");
    }

    public static void min(Long num, Long min, String errCode, String errMessage) {
        if (null != num && num < min) {
            throw errorToExceptionFunc.apply(errCode, errMessage);
        }
    }

    public static void min(Long num, Long min, String errMessage) {
        Validates.min(num, min, null, errMessage);
    }

    public static void min(Long num, Long min) {
        Validates.min(num, min, "[Assertion failed] Must not less than min");
    }

    public static void max(Long num, Long max, String errCode, String errMessage) {
        if (null != num && num > max) {
            throw errorToExceptionFunc.apply(errCode, errMessage);
        }
    }

    public static void max(Long num, Long max, String errMessage) {
        Validates.max(num, max, null, errMessage);
    }

    public static void max(Long num, Long max) {
        Validates.max(num, max, "[Assertion failed] Must not greater than max");
    }

    public static void range(Double num, Double min, Double max, String errCode, String errMessage) {
        Boolean notInRange = null != num && (num < min || num > max);
        if (notInRange.booleanValue()) {
            throw errorToExceptionFunc.apply(errCode, errMessage);
        }
    }

    public static void range(Double num, Double min, Double max, String errMessage) {
        Validates.range(num, min, max, null, errMessage);
    }

    public static void range(Double num, Double min, Double max) {
        Validates.range(num, min, max, "[Assertion failed] Must not exceed range");
    }

    public static void min(Double num, Double min, String errCode, String errMessage) {
        if (null != num && num < min) {
            throw errorToExceptionFunc.apply(errCode, errMessage);
        }
    }

    public static void min(Double num, Double min, String errMessage) {
        Validates.min(num, min, null, errMessage);
    }

    public static void min(Double num, Double min) {
        Validates.min(num, min, "[Assertion failed] Must not less than min");
    }

    public static void max(Double num, Double max, String errCode, String errMessage) {
        if (null != num && num > max) {
            throw errorToExceptionFunc.apply(errCode, errMessage);
        }
    }

    public static void max(Double num, Double max, String errMessage) {
        Validates.max(num, max, null, errMessage);
    }

    public static void max(Double num, Double max) {
        Validates.max(num, max, "[Assertion failed] Must not greater than max");
    }

    public static void range(Float num, Float min, Float max, String errCode, String errMessage) {
        Boolean notInRange = null != num && (num.floatValue() < min.floatValue() || num.floatValue() > max.floatValue());
        if (notInRange.booleanValue()) {
            throw errorToExceptionFunc.apply(errCode, errMessage);
        }
    }

    public static void range(Float num, Float min, Float max, String errMessage) {
        Validates.range(num, min, max, null, errMessage);
    }

    public static void range(Float num, Float min, Float max) {
        Validates.range(num, min, max, "[Assertion failed] Must not exceed range");
    }

    public static void min(Float num, Float min, String errCode, String errMessage) {
        if (null != num && num.floatValue() < min.floatValue()) {
            throw errorToExceptionFunc.apply(errCode, errMessage);
        }
    }

    public static void min(Float num, Float min, String errMessage) {
        Validates.min(num, min, null, errMessage);
    }

    public static void min(Float num, Float min) {
        Validates.min(num, min, "[Assertion failed] Must not less than min");
    }

    public static void max(Float num, Float max, String errCode, String errMessage) {
        if (null != num && num.floatValue() > max.floatValue()) {
            throw errorToExceptionFunc.apply(errCode, errMessage);
        }
    }

    public static void max(Float num, Float max, String errMessage) {
        Validates.max(num, max, null, errMessage);
    }

    public static void max(Float num, Float max) {
        Validates.max(num, max, "[Assertion failed] Must not greater than max");
    }

    public static void range(BigDecimal num, BigDecimal min, BigDecimal max, String errCode, String errMessage) {
        Boolean notInRange = null != num && (num.compareTo(min) < 0 || num.compareTo(max) > 0);
        if (notInRange.booleanValue()) {
            throw errorToExceptionFunc.apply(errCode, errMessage);
        }
    }

    public static void range(BigDecimal num, BigDecimal min, BigDecimal max, String errMessage) {
        Validates.range(num, min, max, null, errMessage);
    }

    public static void range(BigDecimal num, BigDecimal min, BigDecimal max) {
        Validates.range(num, min, max, "[Assertion failed] Must not exceed range");
    }

    public static void min(BigDecimal num, BigDecimal min, String errCode, String errMessage) {
        if (null != num && num.compareTo(min) < 0) {
            throw errorToExceptionFunc.apply(errCode, errMessage);
        }
    }

    public static void min(BigDecimal num, BigDecimal min, String errMessage) {
        Validates.min(num, min, null, errMessage);
    }

    public static void min(BigDecimal num, BigDecimal min) {
        Validates.min(num, min, "[Assertion failed] Must not less than min");
    }

    public static void max(BigDecimal num, BigDecimal max, String errCode, String errMessage) {
        if (null != num && num.compareTo(max) > 0) {
            throw errorToExceptionFunc.apply(errCode, errMessage);
        }
    }

    public static void max(BigDecimal num, BigDecimal max, String errMessage) {
        Validates.max(num, max, null, errMessage);
    }

    public static void max(BigDecimal num, BigDecimal max) {
        Validates.max(num, max, "[Assertion failed] Must not greater than max");
    }

    public static void length(String text, Integer min, Integer max, String errCode, String errMessage) {
        Boolean notInLength = null != text && (text.length() < min || text.length() > max);
        if (notInLength.booleanValue()) {
            throw errorToExceptionFunc.apply(errCode, errMessage);
        }
    }

    public static void length(String text, Integer min, Integer max, String errMessage) {
        Validates.length(text, min, max, null, errMessage);
    }

    public static void length(String text, Integer min, Integer max) {
        Validates.length(text, min, max, null, "[Assertion failed] Must not exceed length");
    }

    public static void regex(String text, String regex, String errCode, String errMessage) {
        if (null != text && !Pattern.compile(regex).matcher(text).matches()) {
            throw errorToExceptionFunc.apply(errCode, errMessage);
        }
    }

    public static void regex(String text, String regex, String errMessage) {
        Validates.regex(text, regex, null, errMessage);
    }

    public static void regex(String text, String regex) {
        Validates.regex(text, "[Assertion failed] Must match regex");
    }

    static {
        validationExceptionHolder = new ThreadLocal();
        validator = Validation.buildDefaultValidatorFactory().getValidator();
        errorToExceptionFunc = (errCode, errMessage) -> Optional.ofNullable(errCode).map(errCodeInner -> new ValidateException((String)errCode, (String)errMessage)).orElse(new ValidateException((String)errMessage));
    }
}

