/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.elk.aspect;

import com.taotao.boot.common.utils.common.JsonUtils;
import com.taotao.boot.common.utils.lang.StringUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.elk.properties.ElkHealthLogStatisticProperties;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.dromara.hutool.core.text.StrUtil;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
public class WebControllerAspect {
    private static final String[] TOKEN_KEYS = new String[]{"BaseAuthorized", "Authorized"};
    private final ElkHealthLogStatisticProperties logStatisticProperties;

    public WebControllerAspect(ElkHealthLogStatisticProperties logStatisticProperties) {
        this.logStatisticProperties = logStatisticProperties;
    }

    @Pointcut(value="@within(org.springframework.stereotype.Controller) || @within(org.springframework.web.bind.annotation.RestController)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object handle(ProceedingJoinPoint joinPoint) throws Throwable {
        Object result;
        block5: {
            String ip;
            String outPutParam;
            String inPutParam;
            String uri;
            Exception exception = null;
            result = null;
            long timeSpan = 0L;
            HttpServletRequest request = RequestContextHolder.getRequestAttributes() == null ? null : ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            try {
                long start = System.currentTimeMillis();
                result = joinPoint.proceed();
                timeSpan = System.currentTimeMillis() - start;
                if (!this.logStatisticProperties.getEnabled() || request == null) break block5;
                uri = request.getRequestURI().replace(request.getContextPath(), "");
                inPutParam = this.preHandle(joinPoint, request);
                outPutParam = this.postHandle(result);
                ip = this.getRemoteHost(request);
            }
            catch (Exception e) {
                try {
                    exception = e;
                    throw e;
                }
                catch (Throwable throwable) {
                    if (this.logStatisticProperties.getEnabled() && request != null) {
                        String uri2 = request.getRequestURI().replace(request.getContextPath(), "");
                        String inPutParam2 = this.preHandle(joinPoint, request);
                        String outPutParam2 = this.postHandle(result);
                        String ip2 = this.getRemoteHost(request);
                        LogUtils.info((String)"\u3010\u8fdc\u7a0bip\u3011{},\u3010url\u3011{},\u3010\u8f93\u5165\u3011{},\u3010\u8f93\u51fa\u3011{},\u3010\u5f02\u5e38\u3011{},\u3010\u8017\u65f6\u3011{}ms", (Object[])new Object[]{ip2, uri2, inPutParam2, outPutParam2, exception == null ? "\u65e0" : StrUtil.nullIfEmpty((CharSequence)exception.getMessage()), timeSpan});
                    }
                    throw throwable;
                }
            }
            LogUtils.info((String)"\u3010\u8fdc\u7a0bip\u3011{},\u3010url\u3011{},\u3010\u8f93\u5165\u3011{},\u3010\u8f93\u51fa\u3011{},\u3010\u5f02\u5e38\u3011{},\u3010\u8017\u65f6\u3011{}ms", (Object[])new Object[]{ip, uri, inPutParam, outPutParam, exception == null ? "\u65e0" : StrUtil.nullIfEmpty((CharSequence)exception.getMessage()), timeSpan});
        }
        return result;
    }

    private String preHandle(ProceedingJoinPoint joinPoint, HttpServletRequest request) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method targetMethod = methodSignature.getMethod();
        Annotation[] annotations = targetMethod.getAnnotations();
        StringBuilder sb = new StringBuilder();
        for (String tokenKey : TOKEN_KEYS) {
            String token = request.getHeader(tokenKey);
            if (!StringUtils.isNotBlank((String)token)) continue;
            sb.append("token:").append(token).append(",");
            break;
        }
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().toString().contains("org.springframework.web.bind.annotation")) continue;
            sb.append(JsonUtils.toJSONString((Object)request.getParameterMap()));
        }
        return sb.toString();
    }

    private String postHandle(Object retVal) {
        if (null == retVal) {
            return "";
        }
        return JsonUtils.toJSONString((Object)retVal);
    }

    private String getRemoteHost(HttpServletRequest request) {
        String unknown = "unknown";
        String ip = request.getHeader("x-forwarded-for");
        if (StringUtils.isBlank((String)ip) || unknown.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isBlank((String)ip) || unknown.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isBlank((String)ip) || unknown.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return "0:0:0:0:0:0:0:1".equals(ip) ? "127.0.0.1" : ip;
    }
}

