/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.elk.configuration;

import com.taotao.boot.elk.aspect.WebControllerAspect;
import com.taotao.boot.elk.interceptor.ElkWebInterceptor;
import com.taotao.boot.elk.properties.ElkHealthLogStatisticProperties;
import net.logstash.logback.appender.LogstashTcpSocketAppender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@AutoConfiguration
@ConditionalOnProperty(prefix="taotao.boot.elk.web", name={"enabled"}, havingValue="true")
public class ElkWebInterceptorAutoConfiguration
implements WebMvcConfigurer {
    private final LogstashTcpSocketAppender logstashTcpSocketAppender;

    public ElkWebInterceptorAutoConfiguration(@Autowired(required=false) LogstashTcpSocketAppender logstashTcpSocketAppender) {
        this.logstashTcpSocketAppender = logstashTcpSocketAppender;
    }

    @Bean
    public ElkWebInterceptor elkWebInterceptor() {
        return new ElkWebInterceptor(this.logstashTcpSocketAppender);
    }

    @Bean
    @ConditionalOnClass(name={"org.aspectj.lang.annotation.Aspect"})
    @ConditionalOnProperty(prefix="taotao.boot.elk.web.aspect", name={"enabled"}, havingValue="true")
    public WebControllerAspect webControllerAspect(ElkHealthLogStatisticProperties logStatisticProperties) {
        return new WebControllerAspect(logStatisticProperties);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.elkWebInterceptor());
    }
}

