/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.encrypt.crypto.configuration;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.encrypt.crypto.encrypt.EncryptAspect;
import com.taotao.boot.encrypt.crypto.properties.EncryptProperties;
import org.jasypt.encryption.StringEncryptor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={EncryptProperties.class})
@ConditionalOnProperty(prefix="taotao.boot.encrypt", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class EncryptAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(EncryptAutoConfiguration.class, (String)"taotao-boot-starter-encrypt", (String[])new String[0]);
    }

    @Bean
    @ConditionalOnBean(value={StringEncryptor.class})
    public EncryptAspect encryptAspect(StringEncryptor stringEncryptor) {
        LogUtils.started(EncryptAspect.class, (String)"taotao-boot-starter-web", (String[])new String[0]);
        return new EncryptAspect(stringEncryptor);
    }
}

