/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.encrypt.crypto.encrypt;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.encrypt.crypto.encrypt.EncryptField;
import java.lang.reflect.Field;
import java.util.Objects;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.jasypt.encryption.StringEncryptor;

@Aspect
public class EncryptAspect {
    private final StringEncryptor stringEncryptor;

    public EncryptAspect(StringEncryptor stringEncryptor) {
        this.stringEncryptor = stringEncryptor;
    }

    @Pointcut(value="@annotation(com.taotao.boot.encrypt.crypto.encrypt.EncryptMethod)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint joinPoint) {
        this.encrypt(joinPoint);
        return this.decrypt(joinPoint);
    }

    public void encrypt(ProceedingJoinPoint joinPoint) {
        try {
            Object[] objects;
            for (Object o : objects = joinPoint.getArgs()) {
                if (o instanceof String) {
                    this.encryptValue(o);
                    continue;
                }
                this.handler(o, "encrypt");
            }
        }
        catch (IllegalAccessException e) {
            LogUtils.error((Throwable)e);
        }
    }

    public Object decrypt(ProceedingJoinPoint joinPoint) {
        Object result = null;
        try {
            Object obj = joinPoint.proceed();
            if (obj != null) {
                result = obj instanceof String ? this.decryptValue(obj) : this.handler(obj, "decrypt");
            }
        }
        catch (Throwable e) {
            LogUtils.error((Throwable)e);
        }
        return result;
    }

    private Object handler(Object obj, String type) throws IllegalAccessException {
        Field[] fields;
        if (Objects.isNull(obj)) {
            return null;
        }
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            boolean hasSecureField = field.isAnnotationPresent(EncryptField.class);
            if (!hasSecureField) continue;
            field.setAccessible(true);
            String realValue = (String)field.get(obj);
            String value = "decrypt".equals(type) ? this.stringEncryptor.decrypt(realValue) : this.stringEncryptor.encrypt(realValue);
            field.set(obj, value);
        }
        return obj;
    }

    public String encryptValue(Object realValue) {
        String value = null;
        try {
            value = this.stringEncryptor.encrypt(String.valueOf(realValue));
        }
        catch (Exception ex) {
            return value;
        }
        return value;
    }

    public String decryptValue(Object realValue) {
        String value = String.valueOf(realValue);
        try {
            value = this.stringEncryptor.decrypt(value);
        }
        catch (Exception ex) {
            return value;
        }
        return value;
    }
}

