/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.encrypt.crypto.ext.processor;

import com.taotao.boot.encrypt.crypto.ext.processor.SymmetricCryptoProcessor;
import java.nio.charset.StandardCharsets;
import org.dromara.hutool.core.codec.binary.Base64;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.RandomUtil;
import org.dromara.hutool.crypto.SecureUtil;
import org.dromara.hutool.crypto.symmetric.AES;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESCryptoProcessor
implements SymmetricCryptoProcessor {
    private static final Logger log = LoggerFactory.getLogger(AESCryptoProcessor.class);

    @Override
    public String createKey() {
        return RandomUtil.randomStringUpper((int)16);
    }

    @Override
    public String decrypt(String data, String key) {
        AES aes = SecureUtil.aes((byte[])StrUtil.utf8Str((Object)key).getBytes(StandardCharsets.UTF_8));
        byte[] result = aes.decrypt(Base64.decode((byte[])StrUtil.utf8Str((Object)data).getBytes(StandardCharsets.UTF_8)));
        log.debug("AES crypto decrypt data, value is : [{}]", (Object)result);
        return StrUtil.utf8Str((Object)result);
    }

    @Override
    public String encrypt(String data, String key) {
        AES aes = SecureUtil.aes((byte[])StrUtil.utf8Str((Object)key).getBytes(StandardCharsets.UTF_8));
        byte[] result = aes.encrypt(StrUtil.utf8Str((Object)data).getBytes(StandardCharsets.UTF_8));
        log.debug("AES crypto encrypt data, value is : [{}]", (Object)result);
        return StrUtil.utf8Str((Object)result);
    }
}

