/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.encrypt.crypto.ext.processor;

import com.taotao.boot.cache.redis.repository.RedisRepository;
import com.taotao.boot.encrypt.crypto.ext.processor.AsymmetricCryptoProcessor;
import com.taotao.boot.encrypt.crypto.ext.processor.SecretKey;
import com.taotao.boot.encrypt.crypto.ext.processor.SymmetricCryptoProcessor;
import java.time.Duration;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.core.data.id.IdUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCryptoProcessor {
    private static final Logger log = LoggerFactory.getLogger(HttpCryptoProcessor.class);
    private final AsymmetricCryptoProcessor asymmetricCryptoProcessor;
    private final SymmetricCryptoProcessor symmetricCryptoProcessor;
    private final RedisRepository redisRepository;

    public HttpCryptoProcessor(AsymmetricCryptoProcessor asymmetricCryptoProcessor, SymmetricCryptoProcessor symmetricCryptoProcessor, RedisRepository redisRepository) {
        this.asymmetricCryptoProcessor = asymmetricCryptoProcessor;
        this.symmetricCryptoProcessor = symmetricCryptoProcessor;
        this.redisRepository = redisRepository;
    }

    public String encrypt(String identity, String content) {
        SecretKey secretKey = this.getSecretKey(identity);
        String result = this.symmetricCryptoProcessor.encrypt(content, secretKey.getSymmetricKey());
        log.debug("Encrypt content from [{}] to [{}].", (Object)content, (Object)result);
        return result;
    }

    public String decrypt(String identity, String content) {
        SecretKey secretKey = this.getSecretKey(identity);
        String result = this.symmetricCryptoProcessor.decrypt(content, secretKey.getSymmetricKey());
        log.debug("Decrypt content from [{}] to [{}].", (Object)content, (Object)result);
        return result;
    }

    public SecretKey createSecretKey(String identity, Duration accessTokenValiditySeconds) {
        if (StringUtils.isBlank((CharSequence)identity)) {
            identity = IdUtil.fastUUID();
        }
        SecretKey secretKey = this.asymmetricCryptoProcessor.createSecretKey();
        String symmetricKey = this.symmetricCryptoProcessor.createKey();
        secretKey.setSymmetricKey(symmetricKey);
        secretKey.setIdentity(identity);
        log.debug("Generate secret key, value is : [{}]", (Object)secretKey);
        Duration expire = this.getExpire(accessTokenValiditySeconds);
        this.redisRepository.insert(identity, expire.getSeconds(), (Object)secretKey);
        return secretKey;
    }

    private boolean isSessionValid(String identity) {
        return this.redisRepository.exists(identity);
    }

    private SecretKey getSecretKey(String identity) {
        SecretKey secretKey;
        if (this.isSessionValid(identity) && ObjectUtils.isNotEmpty((Object)(secretKey = (SecretKey)this.redisRepository.get(identity)))) {
            log.trace("Decrypt Or Encrypt content use param identity [{}], cached identity is [{}].", (Object)identity, (Object)secretKey.getIdentity());
            return secretKey;
        }
        throw new RuntimeException("SecretKey key is expired!");
    }

    private Duration getExpire(Duration accessTokenValiditySeconds) {
        if (ObjectUtils.isEmpty((Object)accessTokenValiditySeconds) || accessTokenValiditySeconds.isZero()) {
            return Duration.ofHours(2L);
        }
        return accessTokenValiditySeconds;
    }

    private String decryptFrontendPublicKey(String content, String privateKey) {
        String frontendPublicKey = this.asymmetricCryptoProcessor.decrypt(content, privateKey);
        log.debug("Decrypt frontend public key, value is : [{}]", (Object)frontendPublicKey);
        return frontendPublicKey;
    }

    private String encryptBackendKey(String symmetricKey, String publicKey) {
        String encryptedAesKey = this.asymmetricCryptoProcessor.encrypt(symmetricKey, publicKey);
        log.debug("Encrypt symmetric key use frontend public key, value is : [{}]", (Object)encryptedAesKey);
        return encryptedAesKey;
    }

    public String exchange(String identity, String confidential) {
        SecretKey secretKey = this.getSecretKey(identity);
        String frontendPublicKey = this.decryptFrontendPublicKey(confidential, secretKey.getPrivateKey());
        return this.encryptBackendKey(secretKey.getSymmetricKey(), frontendPublicKey);
    }
}

