/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.encrypt.crypto.ext.processor;

import com.taotao.boot.encrypt.crypto.ext.processor.AsymmetricCryptoProcessor;
import com.taotao.boot.encrypt.crypto.ext.processor.SecretKey;
import java.security.PrivateKey;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.dromara.hutool.core.codec.binary.HexUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.crypto.asymmetric.KeyType;
import org.dromara.hutool.crypto.asymmetric.SM2;
import org.dromara.hutool.crypto.bc.ECKeyUtil;
import org.dromara.hutool.crypto.bc.SmUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM2CryptoProcessor
implements AsymmetricCryptoProcessor {
    private static final Logger log = LoggerFactory.getLogger(SM2CryptoProcessor.class);
    private static final String FLAG = "04";

    @Override
    public SecretKey createSecretKey() {
        SM2 sm2 = SmUtil.sm2();
        sm2.setMode(SM2Engine.Mode.C1C3C2);
        String privateKey = HexUtil.encodeStr((byte[])ECKeyUtil.encodeECPrivateKey((PrivateKey)sm2.getPrivateKey()));
        String publicKey = HexUtil.encodeStr((byte[])((BCECPublicKey)sm2.getPublicKey()).getQ().getEncoded(false));
        SecretKey secretKey = new SecretKey();
        secretKey.setPrivateKey(privateKey);
        secretKey.setPublicKey(publicKey);
        return secretKey;
    }

    @Override
    public String decrypt(String content, String privateKey) {
        SM2 sm2 = SmUtil.sm2((String)privateKey, null);
        sm2.setMode(SM2Engine.Mode.C1C3C2);
        String result = StrUtil.utf8Str((Object)sm2.decrypt(content, KeyType.PrivateKey));
        log.debug("SM2 crypto decrypt data, value is : [{}]", (Object)result);
        return result;
    }

    @Override
    public String encrypt(String content, String publicKey) {
        SM2 sm2 = SmUtil.sm2(null, (String)publicKey);
        String result = new String(sm2.encrypt(content, KeyType.PublicKey));
        log.debug("SM2 crypto encrypt data, value is : [{}]", (Object)result);
        return result;
    }
}

