/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.encrypt.encrypt2.advice;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.encrypt.encrypt2.handler.SecurityHandler;
import com.taotao.boot.encrypt.encrypt2.handler.SensitiveHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;

public abstract class AbstractSecurityAdvice
implements BeanFactoryAware,
InitializingBean {
    public int DEFAULT_CLEAN_DEPTH;
    public List<String> STANDARD_CLASS = new ArrayList<String>();
    protected ConfigurableListableBeanFactory beanFactory;
    protected SecurityHandler securityHandler;
    protected SensitiveHandler sensitiveHandler;

    public abstract String handleSecurity(String var1, Annotation[] var2);

    protected Object handleObject(int currentTime, int maxCleanDepth, Object result, Annotation[] annotations) throws Exception {
        if (Objects.isNull(result)) {
            return null;
        }
        if (currentTime >= maxCleanDepth) {
            LogUtils.warn((String)"currentTime\uff1a{}\uff0cmaxCleanDepth\uff1a{}", (Object[])new Object[]{currentTime, maxCleanDepth});
            return result;
        }
        int nextDepth = currentTime + 1;
        Class<?> resultClass = result.getClass();
        if (String.class.isAssignableFrom(resultClass)) {
            return this.handleSecurity((String)result, annotations);
        }
        if (resultClass.isArray()) {
            this.wrapperNewObjArray((Object[])result, nextDepth, annotations);
        } else {
            if (List.class.isAssignableFrom(resultClass)) {
                this.wrapperNewObjList((List)result, nextDepth, annotations);
                return result;
            }
            if (Set.class.isAssignableFrom(resultClass)) {
                this.wrapperNewObjSet((Set)result, nextDepth, annotations);
                return result;
            }
            if (Map.class.isAssignableFrom(resultClass)) {
                this.wrapperNewObjMap((Map)result, nextDepth, annotations);
                return result;
            }
            if (this.isStandardClass(result)) {
                Field[] declaredFields;
                for (Field field : declaredFields = this.findAllDeclaredFields(resultClass)) {
                    field.setAccessible(true);
                    Object value = field.get(result);
                    if (value == null) continue;
                    annotations = field.getDeclaredAnnotations();
                    Class<?> clazz = value.getClass();
                    if (String.class.isAssignableFrom(clazz)) {
                        field.set(result, this.handleSecurity((String)value, annotations));
                        continue;
                    }
                    if (clazz.isArray()) {
                        this.wrapperNewObjArray((Object[])value, nextDepth, annotations);
                        continue;
                    }
                    if (List.class.isAssignableFrom(clazz)) {
                        this.wrapperNewObjList((List)value, nextDepth, annotations);
                        continue;
                    }
                    if (Set.class.isAssignableFrom(clazz)) {
                        this.wrapperNewObjSet((Set)value, nextDepth, annotations);
                        continue;
                    }
                    if (Map.class.isAssignableFrom(clazz)) {
                        this.wrapperNewObjMap((Map)value, nextDepth, annotations);
                        continue;
                    }
                    field.set(result, this.handleObject(nextDepth, maxCleanDepth, value, annotations));
                }
            }
        }
        return result;
    }

    private Field[] findAllDeclaredFields(Class<?> resultClass) {
        HashSet<Field> fields = new HashSet<Field>();
        Class<?> currentClass = resultClass;
        do {
            fields.addAll(Arrays.asList(currentClass.getDeclaredFields()));
        } while ((currentClass = currentClass.getSuperclass()) != null);
        return fields.toArray(new Field[0]);
    }

    private void wrapperNewObjArray(Object[] valueList, int nextDepth, Annotation[] annotations) throws Exception {
        for (int i = 0; i < valueList.length; ++i) {
            try {
                Object value = valueList[i];
                valueList[i] = this.handleObject(nextDepth, this.DEFAULT_CLEAN_DEPTH, value, annotations);
                continue;
            }
            catch (UnsupportedOperationException e) {
                LogUtils.error((String)"value:{} class:{} is unModify!", (Object[])new Object[]{Arrays.toString(valueList), valueList.getClass().getSimpleName()});
                return;
            }
        }
    }

    private void wrapperNewObjList(List<Object> valueList, int nextDepth, Annotation[] annotations) throws Exception {
        for (int i = 0; i < valueList.size(); ++i) {
            try {
                Object value = valueList.get(i);
                valueList.set(i, this.handleObject(nextDepth, this.DEFAULT_CLEAN_DEPTH, value, annotations));
                continue;
            }
            catch (UnsupportedOperationException e) {
                LogUtils.error((String)"value:{} class:{} is unModify!", (Object[])new Object[]{valueList, valueList.getClass().getSimpleName()});
                return;
            }
        }
    }

    private void wrapperNewObjMap(Map<Object, Object> objectMap, int nextDepth, Annotation[] annotations) throws Exception {
        for (Object key : objectMap.keySet()) {
            try {
                objectMap.put(key, this.handleObject(nextDepth, this.DEFAULT_CLEAN_DEPTH, objectMap.get(key), annotations));
            }
            catch (UnsupportedOperationException e) {
                LogUtils.error((String)"value:{} class:{} is unModify!", (Object[])new Object[]{objectMap, objectMap.getClass().getSimpleName()});
            }
        }
    }

    private void wrapperNewObjSet(Set<Object> objectSet, int nextDepth, Annotation[] annotations) throws Exception {
        LinkedList<Object> objectList = new LinkedList<Object>();
        for (Object obj : objectSet) {
            objectList.add(this.handleObject(nextDepth, this.DEFAULT_CLEAN_DEPTH, obj, annotations));
        }
        try {
            objectSet.clear();
        }
        catch (UnsupportedOperationException e) {
            LogUtils.error((String)"value:{} class:{} is unModify!", (Object[])new Object[]{objectSet, objectSet.getClass().getSimpleName()});
        }
        objectSet.addAll(objectList);
    }

    boolean isStandardClass(Object result) {
        Class<?> clazz = result instanceof Class ? (Class<?>)result : result.getClass();
        for (String standardClass : this.STANDARD_CLASS) {
            if (!clazz.getName().startsWith(standardClass) && !clazz.getName().matches(standardClass)) continue;
            return true;
        }
        return false;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof ConfigurableListableBeanFactory)) {
            throw new IllegalArgumentException("AdvisorAutoProxyCreator requires a ConfigurableListableBeanFactory: " + String.valueOf(beanFactory));
        }
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    private static void sortProcessors(List<?> list, ConfigurableListableBeanFactory beanFactory) {
        Comparator comparatorToUse = null;
        if (beanFactory instanceof DefaultListableBeanFactory) {
            comparatorToUse = ((DefaultListableBeanFactory)beanFactory).getDependencyComparator();
        }
        if (comparatorToUse == null) {
            comparatorToUse = OrderComparator.INSTANCE;
        }
        list.sort(comparatorToUse);
    }

    public void afterPropertiesSet() throws Exception {
        List<SecurityHandler> securityHandlers = this.getBeanByType(SecurityHandler.class);
        List<SensitiveHandler> sensitiveHandlers = this.getBeanByType(SensitiveHandler.class);
        this.securityHandler = securityHandlers.get(0);
        this.sensitiveHandler = sensitiveHandlers.get(0);
    }

    private <T> List<T> getBeanByType(Class<T> tClass) {
        ArrayList list = new ArrayList();
        String[] beanNames = this.beanFactory.getBeanNamesForType(tClass, true, false);
        ArrayList<String> orderedNames = new ArrayList<String>();
        ArrayList<String> nonOrderedNames = new ArrayList<String>();
        for (String beanName : beanNames) {
            if (this.beanFactory.isTypeMatch(beanName, Ordered.class)) {
                orderedNames.add(beanName);
                continue;
            }
            nonOrderedNames.add(beanName);
        }
        ArrayList<Object> orderedBeans = new ArrayList<Object>(orderedNames.size());
        for (String oName : orderedNames) {
            Object t = this.beanFactory.getBean(oName, tClass);
            orderedBeans.add(t);
        }
        AbstractSecurityAdvice.sortProcessors(orderedBeans, this.beanFactory);
        ArrayList<Object> nonOrderedBeans = new ArrayList<Object>(nonOrderedNames.size());
        for (String nName : nonOrderedNames) {
            Object t = this.beanFactory.getBean(nName, tClass);
            nonOrderedBeans.add(t);
        }
        list.addAll(orderedBeans);
        list.addAll(nonOrderedBeans);
        return list;
    }
}

