/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.encrypt.encrypt2.codec;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.encrypt.encrypt2.codec.SecurityProcessor;
import com.taotao.boot.encrypt.encrypt2.constants.SecurityMode;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.core.codec.binary.Base64;
import org.dromara.hutool.core.codec.binary.HexUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.crypto.KeyUtil;
import org.dromara.hutool.crypto.SecureUtil;
import org.dromara.hutool.crypto.symmetric.AES;
import org.dromara.hutool.crypto.symmetric.SymmetricAlgorithm;

public class AESProcessor
implements SecurityProcessor {
    private String secret;
    private AES aes;

    public AESProcessor(String secret) {
        if (StringUtils.isBlank((CharSequence)secret)) {
            secret = AESProcessor.generateKey();
            LogUtils.warn((String)"AESProcessor is not configured with a secret, use randomly generated secret: {}", (Object[])new Object[]{secret});
        }
        this.secret = secret;
        this.aes = SecureUtil.aes((byte[])SecureUtil.decode((String)secret));
    }

    @Override
    public byte[] decrypt(String text) {
        return this.aes.decrypt(text);
    }

    @Override
    public byte[] encrypt(byte[] data) {
        return this.aes.encrypt(data);
    }

    public static String generateKey() {
        return AESProcessor.generateKey(SecurityMode.BASE64);
    }

    public static String generateKey(SecurityMode type) {
        byte[] keyBytes = KeyUtil.generateKey((String)SymmetricAlgorithm.AES.getValue()).getEncoded();
        switch (type) {
            case HEX: {
                return HexUtil.encodeStr((byte[])keyBytes);
            }
        }
        return Base64.encode((byte[])keyBytes);
    }

    public static void main(String[] args) {
        String secret = AESProcessor.generateKey();
        System.out.println(secret);
        AESProcessor processor = new AESProcessor(null);
        byte[] encrypt = processor.encrypt("Java".getBytes());
        String encode1 = Base64.encode((byte[])encrypt);
        System.out.println(encode1);
        byte[] decrypt = processor.decrypt(encode1);
        System.out.println(StrUtil.str((byte[])decrypt, (Charset)CharsetUtil.UTF_8));
    }
}

