/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.encrypt.encrypt2.codec;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.encrypt.encrypt2.codec.SecurityProcessor;
import com.taotao.boot.encrypt.encrypt2.constants.SecurityMode;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.core.codec.binary.Base64;
import org.dromara.hutool.core.codec.binary.HexUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ByteUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.crypto.KeyUtil;
import org.dromara.hutool.crypto.asymmetric.KeyType;
import org.dromara.hutool.crypto.asymmetric.RSA;

public class RSAProcessor
implements SecurityProcessor {
    private String publicKey;
    private String privateKey;
    private RSA rsa;

    public RSAProcessor(String publicKey, String privateKey) {
        if (StringUtils.isBlank((CharSequence)publicKey) || StringUtils.isBlank((CharSequence)publicKey)) {
            Map<String, String> map = RSAProcessor.generateKey();
            publicKey = map.get("PUB");
            privateKey = map.get("PRV");
            LogUtils.warn((String)"RSAProcessor is not configured with a key pair, use randomly generated key pair.\nPublicKey: {}\nPrivateKey: {}", (Object[])new Object[]{publicKey, privateKey});
        }
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.rsa = new RSA(privateKey, publicKey);
    }

    @Override
    public byte[] encrypt(byte[] data) {
        return this.rsa.encrypt(data, KeyType.PublicKey);
    }

    @Override
    public byte[] decrypt(String text) {
        return this.rsa.decrypt(text, KeyType.PrivateKey);
    }

    public static Map<String, String> generateKey() {
        return RSAProcessor.generateKey(SecurityMode.BASE64);
    }

    public static Map<String, String> generateKey(SecurityMode type) {
        String PRV;
        HashMap<String, String> map = new HashMap<String, String>();
        KeyPair pair = KeyUtil.generateKeyPair((String)"RSA");
        map.put("PUB", switch (type) {
            case SecurityMode.HEX -> {
                PRV = HexUtil.encodeStr((byte[])pair.getPrivate().getEncoded(), (boolean)false);
                yield HexUtil.encodeStr((byte[])pair.getPublic().getEncoded(), (boolean)false);
            }
            default -> {
                PRV = Base64.encode((byte[])pair.getPrivate().getEncoded());
                yield Base64.encode((byte[])pair.getPublic().getEncoded());
            }
        });
        map.put("PRV", PRV);
        return map;
    }

    public static void main(String[] args) {
        Map<String, String> map = RSAProcessor.generateKey();
        String PRV = map.get("PRV");
        System.out.println("PRV = " + PRV);
        String PUB = map.get("PUB");
        System.out.println("PUB = " + PUB);
        String text = "JAVA";
        RSAProcessor converter = new RSAProcessor(null, PRV);
        byte[] encrypt = converter.encrypt(ByteUtil.toBytes((CharSequence)text, (Charset)CharsetUtil.UTF_8));
        String encodeHexStr = HexUtil.encodeStr((byte[])encrypt, (boolean)false);
        System.out.println(encodeHexStr);
        byte[] decrypt = converter.decrypt(encodeHexStr);
        System.out.println(StrUtil.str((byte[])decrypt, (Charset)CharsetUtil.UTF_8));
    }
}

