/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.encrypt.encrypt2.codec;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.encrypt.encrypt2.codec.SecurityProcessor;
import com.taotao.boot.encrypt.encrypt2.constants.SecurityMode;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.core.codec.binary.Base64;
import org.dromara.hutool.core.codec.binary.HexUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.crypto.KeyUtil;
import org.dromara.hutool.crypto.asymmetric.KeyType;
import org.dromara.hutool.crypto.asymmetric.SM2;
import org.dromara.hutool.crypto.bc.SmUtil;

public class SM2Processor
implements SecurityProcessor {
    private String publicKey;
    private String privateKey;
    private SM2 sm2;

    public SM2Processor(String publicKey, String privateKey) {
        if (StringUtils.isBlank((CharSequence)publicKey) || StringUtils.isBlank((CharSequence)publicKey)) {
            Map<String, String> map = SM2Processor.generateKey();
            publicKey = map.get("PUB");
            privateKey = map.get("PRV");
            LogUtils.warn((String)"SM2Processor is not configured with a key pair, use randomly generated key pair.\nPublicKey: {}\nPrivateKey: {}", (Object[])new Object[]{publicKey, privateKey});
        }
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.sm2 = SmUtil.sm2((String)privateKey, (String)publicKey);
    }

    @Override
    public byte[] encrypt(byte[] data) {
        return this.sm2.encrypt(data, KeyType.PublicKey);
    }

    @Override
    public byte[] decrypt(String text) {
        return this.sm2.decrypt(text, KeyType.PrivateKey);
    }

    public static Map<String, String> generateKey() {
        return SM2Processor.generateKey(SecurityMode.BASE64);
    }

    public static Map<String, String> generateKey(SecurityMode type) {
        String PRV;
        HashMap<String, String> map = new HashMap<String, String>();
        KeyPair pair = KeyUtil.generateKeyPair((String)"SM2");
        map.put("PUB", switch (type) {
            case SecurityMode.HEX -> {
                PRV = HexUtil.encodeStr((byte[])pair.getPrivate().getEncoded(), (boolean)false);
                yield HexUtil.encodeStr((byte[])pair.getPublic().getEncoded(), (boolean)false);
            }
            default -> {
                PRV = Base64.encode((byte[])pair.getPrivate().getEncoded());
                yield Base64.encode((byte[])pair.getPublic().getEncoded());
            }
        });
        map.put("PRV", PRV);
        return map;
    }

    public static void main(String[] args) {
        Map<String, String> map = SM2Processor.generateKey(SecurityMode.HEX);
        String privateKey = map.get("PRV");
        System.out.println("privateKey = " + privateKey);
        String publicKey = map.get("PUB");
        System.out.println("publicKey = " + publicKey);
        SM2Processor sm2Processor = new SM2Processor(publicKey, privateKey);
        String encode = Base64.encode((byte[])sm2Processor.encrypt("Java".getBytes()));
        System.out.println("\u52a0\u5bc6\u540e\uff1a" + encode);
        byte[] decrypt = sm2Processor.decrypt(encode);
        System.out.println("\u89e3\u5bc6\u540e\uff1a" + StrUtil.str((byte[])decrypt, (Charset)CharsetUtil.UTF_8));
    }
}

