/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.encrypt.encrypt2.codec;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.encrypt.encrypt2.codec.SecurityProcessor;
import com.taotao.boot.encrypt.encrypt2.constants.SecurityMode;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.core.codec.binary.Base64;
import org.dromara.hutool.core.codec.binary.HexUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.crypto.KeyUtil;
import org.dromara.hutool.crypto.SecureUtil;
import org.dromara.hutool.crypto.bc.SmUtil;
import org.dromara.hutool.crypto.symmetric.SymmetricCrypto;

public class SM4Processor
implements SecurityProcessor {
    private String secret;
    private SymmetricCrypto symmetricCrypto;

    public SM4Processor(String secret) {
        if (StringUtils.isBlank((CharSequence)secret)) {
            secret = SM4Processor.generateKey();
            LogUtils.warn((String)"SM4Processor is not configured with a secret, use randomly generated secret: {}", (Object[])new Object[]{secret});
        }
        this.secret = secret;
        this.symmetricCrypto = SmUtil.sm4((byte[])SecureUtil.decode((String)secret));
    }

    @Override
    public byte[] decrypt(String text) {
        return this.symmetricCrypto.decrypt(text);
    }

    @Override
    public byte[] encrypt(byte[] data) {
        return this.symmetricCrypto.encrypt(data);
    }

    public static String generateKey() {
        return SM4Processor.generateKey(SecurityMode.BASE64);
    }

    public static String generateKey(SecurityMode type) {
        byte[] keyBytes = KeyUtil.generateKey((String)"SM4").getEncoded();
        switch (type) {
            case HEX: {
                return HexUtil.encodeStr((byte[])keyBytes);
            }
        }
        return Base64.encode((byte[])keyBytes);
    }

    public static void main(String[] args) {
        String secret = SM4Processor.generateKey();
        System.out.println("secret = " + secret);
        SM4Processor sm4Processor = new SM4Processor("+6cuvzvyrFZpRG9pf3r7eQ==");
        byte[] encrypt = sm4Processor.encrypt("\u5317\u4eac\u5e02\u4e1c\u57ce\u533a\u957f\u5b89\u8857".getBytes());
        String hexStr = Base64.encode((byte[])encrypt);
        System.out.println("decrypt = " + hexStr);
        byte[] decrypt = sm4Processor.decrypt("SSzrI9TBwQeFUf+RCoiyyA==");
        System.out.println("bytes = " + StrUtil.str((byte[])decrypt, (Charset)CharsetUtil.UTF_8));
    }
}

