/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.encrypt.encrypt2.config;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.encrypt.encrypt2.advice.DecryptRequestAdvice;
import com.taotao.boot.encrypt.encrypt2.advice.EncryptResponseAdvice;
import com.taotao.boot.encrypt.encrypt2.annotation.Security;
import com.taotao.boot.encrypt.encrypt2.annotation.Sensitive;
import com.taotao.boot.encrypt.encrypt2.aspect.SecurityAspect;
import com.taotao.boot.encrypt.encrypt2.codec.AESProcessor;
import com.taotao.boot.encrypt.encrypt2.codec.RSAProcessor;
import com.taotao.boot.encrypt.encrypt2.codec.SM2Processor;
import com.taotao.boot.encrypt.encrypt2.codec.SM4Processor;
import com.taotao.boot.encrypt.encrypt2.codec.SecurityProcessor;
import com.taotao.boot.encrypt.encrypt2.config.properties.SecurityProperties;
import com.taotao.boot.encrypt.encrypt2.format.CommonSensitiveProcessor;
import com.taotao.boot.encrypt.encrypt2.format.SensitiveProcessor;
import com.taotao.boot.encrypt.encrypt2.handler.CommonSecurityHandler;
import com.taotao.boot.encrypt.encrypt2.handler.CommonSensitiveHandler;
import com.taotao.boot.encrypt.encrypt2.handler.SecurityHandler;
import com.taotao.boot.encrypt.encrypt2.handler.SensitiveHandler;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={SecurityProperties.class})
public class EncryptAutoConfiguration {
    private SecurityProperties securityProperties;

    public EncryptAutoConfiguration(SecurityProperties securityProperties) {
        this.securityProperties = securityProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="fzy.security", name={"type"}, havingValue="AES")
    public SecurityProcessor aesProcessor() {
        return new AESProcessor(this.securityProperties.getSecret());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="fzy.security", name={"type"}, havingValue="RSA")
    public SecurityProcessor rsaProcessor() {
        return new RSAProcessor(this.securityProperties.getPublicKey(), this.securityProperties.getPrivateKey());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="fzy.security", name={"type"}, havingValue="SM4")
    public SecurityProcessor sm4Processor() {
        return new SM4Processor(this.securityProperties.getSecret());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="fzy.security", name={"type"}, havingValue="SM2")
    public SecurityProcessor sm2Processor() {
        return new SM2Processor(this.securityProperties.getPublicKey(), this.securityProperties.getPrivateKey());
    }

    @Bean
    @ConditionalOnMissingBean
    public SecurityHandler<Security> commonSecurityHandler(@Autowired SecurityProcessor aesProcessor) {
        LogUtils.debug((String)"encrypt-starter loading SecurityProcessor: {}", (Object[])new Object[]{aesProcessor.getClass().getName()});
        return new CommonSecurityHandler(aesProcessor, this.securityProperties.getMode(), this.securityProperties.getCharset());
    }

    @Bean
    @ConditionalOnMissingBean
    public SensitiveProcessor commonSensitiveProcessor() {
        return new CommonSensitiveProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    public SensitiveHandler<Sensitive> commonSensitiveHandler(@Autowired SensitiveProcessor commonSensitiveProcessor) {
        LogUtils.debug((String)"encrypt-starter loading SensitiveHandler: {}", (Object[])new Object[]{commonSensitiveProcessor.getClass().getName()});
        return new CommonSensitiveHandler(commonSensitiveProcessor);
    }

    @Bean
    @ConditionalOnMissingBean
    public DecryptRequestAdvice decryptRequestAdvice() {
        return new DecryptRequestAdvice(this.securityProperties.getMaxDeep(), this.securityProperties.getClassPackage());
    }

    @Bean
    @ConditionalOnMissingBean
    public EncryptResponseAdvice encryptResponseAdvice() {
        List<String> classPackage = this.securityProperties.getClassPackage();
        LogUtils.debug((String)"encrypt-starter scan class packages: {}", (Object[])new Object[]{classPackage});
        return new EncryptResponseAdvice(this.securityProperties.getMaxDeep(), classPackage);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="fzy.security", name={"enable"}, havingValue="true")
    public SecurityAspect securityAspect(@Autowired DecryptRequestAdvice decryptRequestAdvice, @Autowired EncryptResponseAdvice encryptResponseAdvice) {
        return new SecurityAspect(decryptRequestAdvice, encryptResponseAdvice);
    }
}

