/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.encrypt.encrypt2.format;

import com.taotao.boot.encrypt.encrypt2.format.SensitiveProcessor;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.core.text.StrUtil;

public class CommonSensitiveProcessor
implements SensitiveProcessor {
    @Override
    public String format(String text, String type) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return text;
        }
        switch (type) {
            case "CHINESE_NAME": {
                return this.chineseName(text);
            }
            case "ID_CARD": {
                return this.idCardNum(text);
            }
            case "FIXED_PHONE": {
                return this.fixedPhone(text);
            }
            case "MOBILE_PHONE": {
                return this.mobilePhone(text);
            }
            case "ADDRESS": {
                return this.address(text, 8);
            }
            case "EMAIL": {
                return this.email(text);
            }
            case "BANK_CARD": {
                return this.bankCard(text);
            }
            case "PASSWORD": {
                return this.password(text);
            }
            case "CARNUMBER": {
                return this.carNumber(text);
            }
            case "DEFAULT": {
                return CommonSensitiveProcessor.defaultType(text);
            }
        }
        return text;
    }

    public static String defaultType(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return "";
        }
        if (text.length() == 1) {
            return "*";
        }
        if (text.length() == 2) {
            return StringUtils.left((String)text, (int)1) + "*";
        }
        if (text.length() >= 3) {
            return StringUtils.rightPad((String)StringUtils.left((String)text, (int)1), (int)(StringUtils.length((CharSequence)text) - 1), (String)"*") + StringUtils.right((String)text, (int)1);
        }
        return text;
    }

    private String chineseName(String fullName) {
        if (StrUtil.isBlank((CharSequence)fullName)) {
            return "";
        }
        String name = StringUtils.left((String)fullName, (int)1);
        return StringUtils.rightPad((String)name, (int)StringUtils.length((CharSequence)fullName), (String)"*");
    }

    private String idCardNum(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return "";
        }
        String num = StringUtils.right((String)id, (int)4);
        return StringUtils.leftPad((String)num, (int)StringUtils.length((CharSequence)id), (String)"*");
    }

    private String fixedPhone(String num) {
        if (StringUtils.isBlank((CharSequence)num)) {
            return "";
        }
        return StringUtils.leftPad((String)StringUtils.right((String)num, (int)4), (int)StringUtils.length((CharSequence)num), (String)"*");
    }

    private String mobilePhone(String num) {
        if (StringUtils.isBlank((CharSequence)num)) {
            return "";
        }
        return StringUtils.left((String)num, (int)3).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)num, (int)2), (int)StringUtils.length((CharSequence)num), (String)"*"), (String)"***"));
    }

    private String address(String address, int sensitiveSize) {
        if (StringUtils.isBlank((CharSequence)address)) {
            return "";
        }
        int length = StringUtils.length((CharSequence)address);
        return StringUtils.rightPad((String)StringUtils.left((String)address, (int)(length - sensitiveSize)), (int)length, (String)"*");
    }

    private String email(String email) {
        if (StringUtils.isBlank((CharSequence)email)) {
            return "";
        }
        int index = StringUtils.indexOf((CharSequence)email, (CharSequence)"@");
        if (index <= 1) {
            return email;
        }
        return StringUtils.rightPad((String)StringUtils.left((String)email, (int)1), (int)index, (String)"*").concat(StringUtils.mid((String)email, (int)index, (int)StringUtils.length((CharSequence)email)));
    }

    private String bankCard(String cardNum) {
        if (StringUtils.isBlank((CharSequence)cardNum)) {
            return "";
        }
        return StringUtils.left((String)cardNum, (int)6).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)cardNum, (int)4), (int)StringUtils.length((CharSequence)cardNum), (String)"*"), (String)"******"));
    }

    private String password(String password) {
        if (StringUtils.isBlank((CharSequence)password)) {
            return "";
        }
        String pwd = StringUtils.left((String)password, (int)0);
        return StringUtils.rightPad((String)pwd, (int)StringUtils.length((CharSequence)password), (String)"*");
    }

    private String carNumber(String carNumber) {
        if (StringUtils.isBlank((CharSequence)carNumber)) {
            return "";
        }
        return StringUtils.left((String)carNumber, (int)2).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)carNumber, (int)1), (int)StringUtils.length((CharSequence)carNumber), (String)"*"), (String)"**"));
    }
}

