/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.encrypt.encrypt2.handler;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.encrypt.encrypt2.annotation.Security;
import com.taotao.boot.encrypt.encrypt2.codec.SecurityProcessor;
import com.taotao.boot.encrypt.encrypt2.constants.SecurityMode;
import com.taotao.boot.encrypt.encrypt2.handler.SecurityHandler;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import org.dromara.hutool.core.codec.binary.Base64;
import org.dromara.hutool.core.codec.binary.HexUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.springframework.util.Assert;

public class CommonSecurityHandler
implements SecurityHandler<Security> {
    private SecurityProcessor securityProcessor;
    private SecurityMode securityMode;
    private Charset charset = Charset.forName("UTF-8");

    public CommonSecurityHandler(SecurityProcessor securityProcessor, SecurityMode securityMode, String charsetName) {
        Assert.notNull((Object)securityProcessor, (String)"securityProcessor could not be null");
        this.securityProcessor = securityProcessor;
        this.securityMode = securityMode;
        if (charsetName != null && charsetName.length() > 0) {
            this.charset = Charset.forName(charsetName);
        }
    }

    @Override
    public Security acquire(Annotation[] annotations) {
        Security security = null;
        for (int i = 0; i < annotations.length; ++i) {
            if (!(annotations[i] instanceof Security)) continue;
            security = (Security)annotations[i];
            return security;
        }
        return null;
    }

    @Override
    public String handleEncrypt(String source, Security annotation) {
        if (annotation.encrypt()) {
            try {
                byte[] encrypt = this.securityProcessor.encrypt(source.getBytes(this.charset));
                switch (this.securityMode) {
                    case BASE64: {
                        return Base64.encode((byte[])encrypt);
                    }
                    case HEX: {
                        return HexUtil.encodeStr((byte[])encrypt);
                    }
                }
            }
            catch (Exception e) {
                LogUtils.error((String)"encrypt fail: {}, source field value: {}", (Object[])new Object[]{e.getMessage(), source});
            }
        }
        return source;
    }

    @Override
    public String handleDecrypt(String source, Security annotation) {
        if (annotation.decrypt()) {
            try {
                byte[] decrypt = this.securityProcessor.decrypt(source);
                return StrUtil.str((byte[])decrypt, (Charset)this.charset);
            }
            catch (Exception e) {
                LogUtils.error((String)"decrypt fail: {}, source field value: {}", (Object[])new Object[]{e.getMessage(), source});
            }
        }
        return source;
    }
}

