/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.encrypt.encrypt2.handler;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.encrypt.encrypt2.annotation.Sensitive;
import com.taotao.boot.encrypt.encrypt2.format.SensitiveProcessor;
import com.taotao.boot.encrypt.encrypt2.handler.SensitiveHandler;
import java.lang.annotation.Annotation;
import org.springframework.util.Assert;

public class CommonSensitiveHandler
implements SensitiveHandler<Sensitive> {
    private SensitiveProcessor sensitiveProcessor;

    public CommonSensitiveHandler(SensitiveProcessor sensitiveProcessor) {
        Assert.notNull((Object)sensitiveProcessor, (String)"sensitiveProcessor could not be null");
        this.sensitiveProcessor = sensitiveProcessor;
    }

    @Override
    public Sensitive acquire(Annotation[] annotations) {
        Sensitive sensitive = null;
        for (int i = 0; i < annotations.length; ++i) {
            if (!(annotations[i] instanceof Sensitive) || !(sensitive = (Sensitive)annotations[i]).required()) continue;
            return sensitive;
        }
        return null;
    }

    @Override
    public String format(String source, Sensitive annotation) {
        if (annotation.required()) {
            try {
                return this.sensitiveProcessor.format(source, annotation.type());
            }
            catch (Exception e) {
                LogUtils.error((String)"sensitive fail: {}, source field value: {}", (Object[])new Object[]{e.getMessage(), source});
            }
        }
        return source;
    }
}

