/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.encrypt.handler;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.encrypt.annotation.SeparateEncrypt;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class InitHandler {
    public static void handler(FilterConfig filterConfig, Set<String> encryptCacheUri, AtomicBoolean isEncryptAnnotation) {
        List<Object> notTypes;
        List<Object> types;
        WebApplicationContext servletContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)filterConfig.getServletContext());
        Map restControllers = new HashMap();
        Map controllers = new HashMap();
        try {
            controllers = servletContext.getBeansWithAnnotation(Controller.class);
        }
        catch (BeanCreationException e) {
            LogUtils.error((String)e.getMessage(), (Object[])new Object[0]);
        }
        try {
            restControllers = servletContext.getBeansWithAnnotation(RestController.class);
        }
        catch (BeanCreationException e) {
            LogUtils.error((String)e.getMessage(), (Object[])new Object[0]);
        }
        if (restControllers.size() > 0) {
            types = restControllers.values().stream().filter(v -> AnnotationUtils.findAnnotation(v.getClass(), SeparateEncrypt.class) != null).toList();
            notTypes = restControllers.values().stream().filter(v -> AnnotationUtils.findAnnotation(v.getClass(), SeparateEncrypt.class) == null).toList();
            InitHandler.restcontrollerTypesHandler(types, encryptCacheUri);
            InitHandler.restcontrollerNotTypesHandler(notTypes, encryptCacheUri);
        }
        if (controllers.size() > 0) {
            types = controllers.values().stream().filter(v -> AnnotationUtils.findAnnotation(v.getClass(), SeparateEncrypt.class) != null).toList();
            notTypes = controllers.values().stream().filter(v -> AnnotationUtils.findAnnotation(v.getClass(), SeparateEncrypt.class) == null).toList();
            InitHandler.controllerTypesHandler(types, encryptCacheUri);
            InitHandler.controllerNotTypesHandler(notTypes, encryptCacheUri);
        }
        if (encryptCacheUri.size() > 0) {
            isEncryptAnnotation.set(true);
        }
    }

    private static void controllerNotTypesHandler(List<Object> types, Set<String> cacheUrl) {
        if (types.size() > 0) {
            types.forEach(t -> {
                Class<?> aClass = t.getClass();
                Method[] declaredMethods = aClass.getDeclaredMethods();
                String[] finalTypeUrl = InitHandler.typeUrl(aClass);
                List<Method> methods = Arrays.stream(declaredMethods).filter(d -> AnnotationUtils.findAnnotation((Method)d, SeparateEncrypt.class) != null).toList();
                if (methods.size() == 0) {
                    return;
                }
                InitHandler.methodHandler(methods, finalTypeUrl, cacheUrl);
            });
        }
    }

    private static void controllerTypesHandler(List<Object> types, Set<String> cacheUrl) {
        if (types.size() > 0) {
            types.forEach(t -> {
                Class<?> aClass = t.getClass();
                Method[] declaredMethods = aClass.getDeclaredMethods();
                String[] finalTypeUrl = InitHandler.typeUrl(aClass);
                if (declaredMethods.length == 0) {
                    return;
                }
                List<Method> methods = Arrays.asList(declaredMethods);
                InitHandler.methodHandler(methods, finalTypeUrl, cacheUrl);
            });
        }
    }

    private static void restcontrollerNotTypesHandler(List<Object> types, Set<String> cacheUrl) {
        if (types.size() > 0) {
            types.forEach(t -> {
                Class<?> aClass = t.getClass();
                Method[] declaredMethods = aClass.getDeclaredMethods();
                String[] finalTypeUrl = InitHandler.typeUrl(aClass);
                List<Method> methods = Arrays.stream(declaredMethods).filter(d -> AnnotationUtils.findAnnotation((Method)d, SeparateEncrypt.class) != null).toList();
                if (methods.size() == 0) {
                    return;
                }
                InitHandler.restMethodHandler(methods, finalTypeUrl, cacheUrl);
            });
        }
    }

    private static void restcontrollerTypesHandler(List<Object> types, Set<String> cacheUrl) {
        if (types.size() > 0) {
            types.forEach(t -> {
                Class<?> aClass = t.getClass();
                Method[] declaredMethods = aClass.getDeclaredMethods();
                String[] finalTypeUrl = InitHandler.typeUrl(aClass);
                if (declaredMethods.length == 0) {
                    return;
                }
                List<Method> methods = Arrays.asList(declaredMethods);
                InitHandler.restMethodHandler(methods, finalTypeUrl, cacheUrl);
            });
        }
    }

    private static String[] typeUrl(Class<?> aClass) {
        String[] typeUrl = null;
        if (AnnotationUtils.findAnnotation(aClass, RequestMapping.class) != null) {
            typeUrl = ((RequestMapping)AnnotationUtils.findAnnotation(aClass, RequestMapping.class)).value();
        }
        return typeUrl;
    }

    private static void restMethodHandler(List<Method> methods, String[] finalTypeUrl, Set<String> cacheUrl) {
        methods.forEach(m -> {
            if (AnnotationUtils.findAnnotation((Method)m, PostMapping.class) != null || AnnotationUtils.findAnnotation((Method)m, RequestMapping.class) != null && Arrays.stream(((RequestMapping)AnnotationUtils.findAnnotation((Method)m, RequestMapping.class)).method()).allMatch(r -> !r.equals((Object)RequestMethod.GET))) {
                InitHandler.urlHandler(m, finalTypeUrl, cacheUrl);
            }
        });
    }

    private static void methodHandler(List<Method> methods, String[] finalTypeUrl, Set<String> cacheUrl) {
        methods.forEach(m -> {
            if (AnnotationUtils.findAnnotation((Method)m, PostMapping.class) != null && AnnotationUtils.findAnnotation((Method)m, ResponseBody.class) != null || AnnotationUtils.findAnnotation((Method)m, RequestMapping.class) != null && Arrays.stream(((RequestMapping)AnnotationUtils.findAnnotation((Method)m, RequestMapping.class)).method()).allMatch(r -> !r.equals((Object)RequestMethod.GET)) && AnnotationUtils.findAnnotation((Method)m, ResponseBody.class) != null) {
                InitHandler.urlHandler(m, finalTypeUrl, cacheUrl);
            }
        });
    }

    private static void urlHandler(Method m, String[] finalTypeUrl, Set<String> cacheUrl) {
        String[] urls = null;
        urls = AnnotationUtils.findAnnotation((Method)m, PostMapping.class) != null ? ((PostMapping)AnnotationUtils.findAnnotation((Method)m, PostMapping.class)).value() : ((RequestMapping)AnnotationUtils.findAnnotation((Method)m, RequestMapping.class)).value();
        Arrays.stream(urls).forEach(u -> {
            if (!u.startsWith("/")) {
                u = "/".concat((String)u);
            }
            if (finalTypeUrl != null && finalTypeUrl.length > 0) {
                String finalU = u;
                Arrays.stream(finalTypeUrl).forEach(f -> {
                    String uri;
                    if (!f.startsWith("/")) {
                        f = "/".concat((String)f);
                    }
                    if ((uri = f.concat(finalU).replaceAll("//+", "/")).endsWith("/")) {
                        uri = uri.substring(0, uri.length() - 1);
                    }
                    cacheUrl.add(uri);
                });
            } else {
                String uri = u.replaceAll("//+", "/");
                if (uri.endsWith("/")) {
                    uri = uri.substring(0, uri.length() - 1);
                }
                cacheUrl.add(uri);
            }
        });
    }
}

