/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.encrypt.handler.impl;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.encrypt.entity.RsaKey;
import com.taotao.boot.encrypt.exception.EncryptException;
import com.taotao.boot.encrypt.handler.EncryptHandler;
import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;

public class RsaEncryptHandler
implements EncryptHandler {
    private static final String KEY_ALGORITHM = "RSA";
    private static final int KEY_SIZE = 1024;
    private static final String PUBLIC_KEY = "RSAPublicKey";
    private static final String PRIVATE_KEY = "RSAPrivateKey";
    private static final int MAX_ENCODE_BLOCK = 117;
    private static final int MAX_DECODE_BLOCK = 128;
    private String publicKey;
    private String privateKey;

    @Override
    public byte[] encode(byte[] content) {
        try {
            return RsaEncryptHandler.encryptByPublicKey(content, Base64.getDecoder().decode(this.publicKey));
        }
        catch (Exception e) {
            LogUtils.error((String)e.getMessage(), (Object[])new Object[0]);
            throw new EncryptException("rsa\u52a0\u5bc6\u9519\u8bef", e);
        }
    }

    @Override
    public byte[] decode(byte[] content) {
        try {
            return RsaEncryptHandler.decryptByPrivateKey(Base64.getDecoder().decode(content), Base64.getDecoder().decode(this.privateKey));
        }
        catch (Exception e) {
            LogUtils.error((String)e.getMessage(), (Object[])new Object[0]);
            throw new EncryptException("rsa\u89e3\u5bc6\u9519\u8bef", e);
        }
    }

    public static RsaKey getRsaKeys() throws Exception {
        Map<String, Object> keyMap = RsaEncryptHandler.initKey();
        byte[] publicKey = RsaEncryptHandler.getPublicKey(keyMap);
        byte[] privateKey = RsaEncryptHandler.getPrivateKey(keyMap);
        RsaKey rsaKey = new RsaKey();
        rsaKey.setPublicKey(Base64.getEncoder().encodeToString(publicKey));
        rsaKey.setPrivateKey(Base64.getEncoder().encodeToString(privateKey));
        return rsaKey;
    }

    private static Map<String, Object> initKey() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGenerator.initialize(1024);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        keyMap.put(PUBLIC_KEY, publicKey);
        keyMap.put(PRIVATE_KEY, privateKey);
        return keyMap;
    }

    private static byte[] encryptByPrivateKey(byte[] data, byte[] key) throws Exception {
        byte[] encryptedData = new byte[]{};
        if (data.length == 0) {
            return encryptedData;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(key);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(1, privateKey);
            encryptedData = Base64.getEncoder().encode(RsaEncryptHandler.doFinal(data, cipher, out, 117));
        }
        return encryptedData;
    }

    private static byte[] encryptByPublicKey(byte[] data, byte[] key) throws Exception {
        byte[] encryptedData = new byte[]{};
        if (data.length == 0) {
            return encryptedData;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(key);
            PublicKey pubKey = keyFactory.generatePublic(x509KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(1, pubKey);
            encryptedData = Base64.getEncoder().encode(RsaEncryptHandler.doFinal(data, cipher, out, 117));
        }
        return encryptedData;
    }

    private static byte[] decryptByPrivateKey(byte[] data, byte[] key) throws Exception {
        byte[] encryptedData = new byte[]{};
        if (data.length == 0) {
            return encryptedData;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(key);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(2, privateKey);
            encryptedData = RsaEncryptHandler.doFinal(data, cipher, out, 128);
        }
        return encryptedData;
    }

    private static byte[] decryptByPublicKey(byte[] data, byte[] key) throws Exception {
        byte[] encryptedData = new byte[]{};
        if (data.length == 0) {
            return encryptedData;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(key);
            PublicKey pubKey = keyFactory.generatePublic(x509KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(2, pubKey);
            encryptedData = RsaEncryptHandler.doFinal(data, cipher, out, 128);
        }
        return encryptedData;
    }

    private static byte[] getPrivateKey(Map<String, Object> keyMap) {
        Key key = (Key)keyMap.get(PRIVATE_KEY);
        return key.getEncoded();
    }

    private static byte[] getPublicKey(Map<String, Object> keyMap) throws Exception {
        Key key = (Key)keyMap.get(PUBLIC_KEY);
        return key.getEncoded();
    }

    private static byte[] doFinal(byte[] data, Cipher cipher, ByteArrayOutputStream out, int MAX_BLOCK) throws BadPaddingException, IllegalBlockSizeException {
        int inputLen = data.length;
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > MAX_BLOCK ? cipher.doFinal(data, offSet, MAX_BLOCK) : cipher.doFinal(data, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * MAX_BLOCK;
        }
        return out.toByteArray();
    }
}

