/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.encrypt.handler.impl;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.encrypt.exception.EncryptException;
import com.taotao.boot.encrypt.handler.SignEncryptHandler;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.dromara.hutool.crypto.digest.MD5;

public class SignEncryptHandlerImpl
implements SignEncryptHandler {
    @Override
    public Object handle(Object proceed, long timeout, TimeUnit timeUnit, String signSecret, Map<Object, Object> jsonMap) throws EncryptException {
        Object sign = jsonMap.get("sign");
        Object timestamp = jsonMap.get("timestamp");
        this.checkParam(sign, timestamp, timeout, timeUnit);
        String digestMd5 = this.getDigest(jsonMap, signSecret, StandardCharsets.UTF_8);
        LogUtils.debug((String)("\u52a0\u5bc6\u540e\u7684\u5b57\u7b26\uff1a" + digestMd5), (Object[])new Object[0]);
        if (!digestMd5.equals(sign)) {
            throw new EncryptException("Illegal request,Decryption failed");
        }
        return proceed;
    }

    private void checkParam(Object sign, Object timestamp, long timeout, TimeUnit timeUnit) {
        long timestampLong;
        if (sign == null) {
            throw new EncryptException("Illegal request,Sign does not exist");
        }
        if (timestamp == null) {
            throw new EncryptException("Illegal request,timestamp does not exist");
        }
        long now = System.currentTimeMillis();
        if (now >= (timestampLong = Long.parseLong(timestamp.toString())) + timeout || now < timestampLong) {
            throw new EncryptException("\u975e\u6cd5\u8bf7\u6c42\uff0c\u8bf7\u6c42\u8d85\u65f6");
        }
    }

    private String getDigest(Map<Object, Object> map, String sortSignSecret, Charset charset) {
        StringBuilder sb = new StringBuilder();
        map.entrySet().stream().filter(entry -> entry != null && !"sign".equals(entry.getKey())).sorted(Comparator.comparing(entry -> entry.getKey().toString())).forEach(entry -> sb.append(entry.getKey().toString()).append("=").append(entry.getValue().toString()).append("&"));
        sb.append("secret").append("=").append(sortSignSecret);
        return MD5.of().digestHex16(sb.toString(), charset);
    }
}

