/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.encrypt.sign.advice;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.taotao.boot.encrypt.sign.annotation.FieldBody;
import com.taotao.boot.encrypt.sign.annotation.decrypt.AESDecryptBody;
import com.taotao.boot.encrypt.sign.annotation.decrypt.DESDecryptBody;
import com.taotao.boot.encrypt.sign.annotation.decrypt.DecryptBody;
import com.taotao.boot.encrypt.sign.annotation.decrypt.RSADecryptBody;
import com.taotao.boot.encrypt.sign.bean.DecryptAnnotationInfoBean;
import com.taotao.boot.encrypt.sign.bean.DecryptHttpInputMessage;
import com.taotao.boot.encrypt.sign.enums.DecryptBodyMethod;
import com.taotao.boot.encrypt.sign.exception.DecryptBodyFailException;
import com.taotao.boot.encrypt.sign.exception.DecryptMethodNotFoundException;
import com.taotao.boot.encrypt.sign.properties.EncryptBodyProperties;
import com.taotao.boot.encrypt.sign.util.CommonUtils;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.reflect.FieldUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.crypto.SecureUtil;
import org.dromara.hutool.crypto.asymmetric.RSA;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;

@Order(value=1)
@RestControllerAdvice(basePackages={"com.taotao.cloud.*.biz.api.controller", "com.taotao.cloud.*.facade.controller.**"})
public class DecryptRequestBodyAdvice
implements RequestBodyAdvice {
    private final EncryptBodyProperties config;
    private final ObjectMapper objectMapper;

    public DecryptRequestBodyAdvice(ObjectMapper objectMapper, EncryptBodyProperties config) {
        this.objectMapper = objectMapper;
        this.config = config;
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        if (this.hasDecryptAnnotation(methodParameter.getDeclaringClass())) {
            return true;
        }
        Method method = methodParameter.getMethod();
        if (method != null) {
            Class<?>[] parameterTypes;
            if (this.hasDecryptAnnotation(method)) {
                return true;
            }
            for (Class<?> parameterType : parameterTypes = method.getParameterTypes()) {
                if (!this.hasDecryptAnnotation(parameterType)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasDecryptAnnotation(AnnotatedElement annotatedElement) {
        return annotatedElement.isAnnotationPresent(DecryptBody.class) || annotatedElement.isAnnotationPresent(AESDecryptBody.class) || annotatedElement.isAnnotationPresent(DESDecryptBody.class) || annotatedElement.isAnnotationPresent(RSADecryptBody.class);
    }

    public Object handleEmptyBody(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    public HttpInputMessage beforeBodyRead(HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        Class<?> targetTypeClass;
        String body;
        try {
            body = IoUtil.read((InputStream)inputMessage.getBody(), (Charset)this.config.getEncoding());
        }
        catch (Exception e) {
            throw new DecryptBodyFailException("Unable to get request body data, please check if the sending data body or request method is in compliance with the specification. (\u65e0\u6cd5\u83b7\u53d6\u8bf7\u6c42\u6b63\u6587\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u53d1\u9001\u6570\u636e\u4f53\u6216\u8bf7\u6c42\u65b9\u6cd5\u662f\u5426\u7b26\u5408\u89c4\u8303\u3002)");
        }
        if (body == null || StrUtil.isEmpty((CharSequence)body)) {
            throw new DecryptBodyFailException("The request body is NULL or an empty string, so the decryption failed. (\u8bf7\u6c42\u6b63\u6587\u4e3aNULL\u6216\u4e3a\u7a7a\u5b57\u7b26\u4e32\uff0c\u56e0\u6b64\u89e3\u5bc6\u5931\u8d25\u3002)");
        }
        try {
            targetTypeClass = Class.forName(targetType.getTypeName());
        }
        catch (ClassNotFoundException e) {
            throw new DecryptBodyFailException(e.getMessage());
        }
        String decryptBody = null;
        DecryptAnnotationInfoBean methodAnnotation = this.getDecryptAnnotation(parameter.getMethod());
        if (methodAnnotation != null) {
            decryptBody = this.switchDecrypt(body, methodAnnotation);
        } else if (this.hasDecryptAnnotation(targetTypeClass)) {
            if (targetTypeClass.isAnnotationPresent(FieldBody.class)) {
                try {
                    Object bodyInstance = this.objectMapper.readValue(body, targetTypeClass);
                    Object decryptBodyInstance = this.eachClassField(bodyInstance, targetTypeClass);
                    decryptBody = this.objectMapper.writeValueAsString(decryptBodyInstance);
                }
                catch (Exception e) {
                    throw new DecryptBodyFailException(e.getMessage());
                }
            } else {
                DecryptAnnotationInfoBean classAnnotation = this.getDecryptAnnotation(targetTypeClass);
                if (classAnnotation != null) {
                    decryptBody = this.switchDecrypt(body, classAnnotation);
                }
            }
        } else {
            DecryptAnnotationInfoBean classAnnotation = this.getDecryptAnnotation(parameter.getDeclaringClass());
            if (classAnnotation != null) {
                decryptBody = this.switchDecrypt(body, classAnnotation);
            }
        }
        if (decryptBody == null) {
            throw new DecryptBodyFailException("Decryption error, please check if the selected source data is encrypted correctly. (\u89e3\u5bc6\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u9009\u62e9\u7684\u6e90\u6570\u636e\u7684\u52a0\u5bc6\u65b9\u5f0f\u662f\u5426\u6b63\u786e\u3002)");
        }
        try {
            return new DecryptHttpInputMessage(IoUtil.toStream((String)decryptBody, (Charset)this.config.getEncoding()), inputMessage.getHeaders());
        }
        catch (Exception e) {
            throw new DecryptBodyFailException("The string is converted to a stream format exception. Please check if the format such as encoding is correct. (\u5b57\u7b26\u4e32\u8f6c\u6362\u6210\u6d41\u683c\u5f0f\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7f16\u7801\u7b49\u683c\u5f0f\u662f\u5426\u6b63\u786e\u3002)");
        }
    }

    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    private Object eachClassField(Object body, Class<?> clazz) {
        Field[] declaredFields;
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            Object fieldValue;
            field.setAccessible(true);
            DecryptAnnotationInfoBean decryptAnnotation = this.getDecryptAnnotation(field);
            Class<?> type = field.getType();
            if (decryptAnnotation != null) {
                FieldBody fieldBody = field.getAnnotation(FieldBody.class);
                if (fieldBody != null) {
                    Field setField = FieldUtil.getField(clazz, (String)fieldBody.field());
                    if (setField == null || !setField.getType().equals(String.class)) continue;
                    Object fieldValue2 = FieldUtil.getFieldValue((Object)body, (Field)setField);
                    String decryptResult = this.switchDecrypt(String.valueOf(fieldValue2), decryptAnnotation);
                    FieldUtil.setFieldValue((Object)body, (Field)field, (Object)decryptResult);
                    continue;
                }
                if (!type.equals(String.class)) continue;
                String decryptResult = this.switchDecrypt(String.valueOf(FieldUtil.getFieldValue((Object)body, (Field)field)), decryptAnnotation);
                FieldUtil.setFieldValue((Object)body, (Field)field, (Object)decryptResult);
                continue;
            }
            if (CommonUtils.isConvertToString(type) || (fieldValue = FieldUtil.getFieldValue((Object)body, (Field)field)) == null) continue;
            this.eachClassField(fieldValue, type);
        }
        return body;
    }

    private DecryptAnnotationInfoBean getDecryptAnnotation(AnnotatedElement annotatedElement) {
        Annotation decryptBody;
        if (annotatedElement == null) {
            return null;
        }
        if (annotatedElement.isAnnotationPresent(DecryptBody.class) && (decryptBody = annotatedElement.getAnnotation(DecryptBody.class)) != null) {
            return DecryptAnnotationInfoBean.builder().decryptBodyMethod(decryptBody.value()).key(decryptBody.otherKey()).build();
        }
        if (annotatedElement.isAnnotationPresent(DESDecryptBody.class) && (decryptBody = annotatedElement.getAnnotation(DESDecryptBody.class)) != null) {
            return DecryptAnnotationInfoBean.builder().decryptBodyMethod(DecryptBodyMethod.DES).key(decryptBody.key()).build();
        }
        if (annotatedElement.isAnnotationPresent(AESDecryptBody.class) && (decryptBody = annotatedElement.getAnnotation(AESDecryptBody.class)) != null) {
            return DecryptAnnotationInfoBean.builder().decryptBodyMethod(DecryptBodyMethod.AES).key(decryptBody.key()).build();
        }
        if (annotatedElement.isAnnotationPresent(RSADecryptBody.class) && (decryptBody = annotatedElement.getAnnotation(RSADecryptBody.class)) != null) {
            return DecryptAnnotationInfoBean.builder().decryptBodyMethod(DecryptBodyMethod.RSA).key(decryptBody.key()).rsaKeyType(decryptBody.type()).build();
        }
        return null;
    }

    private String switchDecrypt(String formatStringBody, DecryptAnnotationInfoBean infoBean) {
        DecryptBodyMethod method = infoBean.getDecryptBodyMethod();
        if (method == null) {
            throw new DecryptMethodNotFoundException();
        }
        String key = infoBean.getKey();
        if (method == DecryptBodyMethod.DES) {
            key = CommonUtils.checkAndGetKey(this.config.getDesKey(), key, "DES-KEY");
            return SecureUtil.des((byte[])key.getBytes()).decryptStr(formatStringBody);
        }
        if (method == DecryptBodyMethod.AES) {
            key = CommonUtils.checkAndGetKey(this.config.getAesKey(), key, "AES-KEY");
            return SecureUtil.aes((byte[])key.getBytes()).decryptStr(formatStringBody);
        }
        if (method == DecryptBodyMethod.RSA) {
            RSA rsa = CommonUtils.infoBeanToRsaInstance(infoBean);
            return rsa.decryptStr(formatStringBody, infoBean.getRsaKeyType().toolType);
        }
        throw new DecryptBodyFailException();
    }
}

