/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.encrypt.sign.configuration;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.encrypt.sign.advice.DecryptRequestBodyAdvice;
import com.taotao.boot.encrypt.sign.advice.EncryptResponseBodyAdvice;
import com.taotao.boot.encrypt.sign.aspect.SignAspect;
import com.taotao.boot.encrypt.sign.properties.EncryptBodyProperties;
import com.taotao.boot.encrypt.sign.properties.EncryptProperties;
import com.taotao.boot.encrypt.sign.properties.SignProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.StreamUtils;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@AutoConfiguration
@ConditionalOnProperty(prefix="taotao.boot.sign", name={"enabled"}, havingValue="true")
@Import(value={EncryptResponseBodyAdvice.class, DecryptRequestBodyAdvice.class, SignAspect.class})
@EnableConfigurationProperties(value={EncryptBodyProperties.class, EncryptProperties.class, SignProperties.class})
public class SignAutoConfiguration
implements WebMvcConfigurer,
InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(SignAutoConfiguration.class, (String)"taotao-boot-starter-encrypt", (String[])new String[0]);
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        MappingJackson2HttpMessageConverter converter = this.mappingJackson2HttpMessageConverter();
        converter.setSupportedMediaTypes((List)new LinkedList<MediaType>(){
            {
                this.add(MediaType.TEXT_HTML);
                this.add(MediaType.APPLICATION_JSON);
            }
        });
        converters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)converter);
    }

    public MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter() {
        return new MappingJackson2HttpMessageConverter(this){

            protected void writeInternal(Object object, Type type, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
                if (object instanceof String) {
                    Charset charset = this.getDefaultCharset();
                    if (charset == null) {
                        charset = StandardCharsets.UTF_8;
                    }
                    StreamUtils.copy((String)((String)object), (Charset)charset, (OutputStream)outputMessage.getBody());
                } else {
                    super.writeInternal(object, type, outputMessage);
                }
            }
        };
    }
}

