/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.encrypt.sign.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.encrypt.sign.bean.ISecurityInfo;
import com.taotao.boot.encrypt.sign.enums.RSAKeyType;
import com.taotao.boot.encrypt.sign.exception.EncryptBodyFailException;
import com.taotao.boot.encrypt.sign.exception.IllegalSecurityTypeException;
import com.taotao.boot.encrypt.sign.exception.KeyNotConfiguredException;
import org.dromara.hutool.core.reflect.ClassUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.crypto.SecureUtil;
import org.dromara.hutool.crypto.asymmetric.RSA;

public class CommonUtils {
    public static String checkAndGetKey(String k1, String k2, String keyName) {
        if (StrUtil.isEmpty((CharSequence)k1) && StrUtil.isEmpty((CharSequence)k2)) {
            throw new KeyNotConfiguredException(String.format("%s is not configured (\u672a\u914d\u7f6e%s)", keyName, keyName));
        }
        if (k1 == null) {
            return k2;
        }
        return k1;
    }

    public static RSA infoBeanToRsaInstance(ISecurityInfo info) {
        return switch (info.getRsaKeyType()) {
            case RSAKeyType.PUBLIC -> new RSA(null, SecureUtil.decode((String)info.getKey()));
            case RSAKeyType.PRIVATE -> new RSA(SecureUtil.decode((String)info.getKey()), null);
            default -> throw new IllegalSecurityTypeException();
        };
    }

    public static boolean isConvertToString(Class<?> clazz) {
        return clazz.equals(String.class) || ClassUtil.isPrimitiveWrapper(clazz);
    }

    public static String convertToStringOrJson(Object val, ObjectMapper mapper) {
        if (CommonUtils.isConvertToString(val.getClass())) {
            return String.valueOf(val);
        }
        try {
            return mapper.writeValueAsString(val);
        }
        catch (JsonProcessingException e) {
            LogUtils.error((Throwable)e);
            throw new EncryptBodyFailException(e.getMessage());
        }
    }
}

