/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.idempotent.configuration;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.idempotent.aop.IdempotentAspect;
import com.taotao.boot.idempotent.properties.IdempotentProperties;
import com.taotao.boot.lock.support.DistributedLock;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={IdempotentProperties.class})
@ConditionalOnProperty(prefix="taotao.boot.idempotent", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class IdempotentAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(IdempotentAutoConfiguration.class, (String)"taotao-boot-starter-idempotent", (String[])new String[0]);
    }

    @Bean
    @ConditionalOnBean
    public IdempotentAspect idempotentAspect(DistributedLock distributedLock) {
        return new IdempotentAspect(distributedLock);
    }
}

