/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.idempotent.enhance.core.aspect;

import com.taotao.boot.common.utils.log.LogUtils;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class IdempotentAnnotationProvider {
    private static final ParameterNameDiscoverer NAME_DISCOVERER = new DefaultParameterNameDiscoverer();
    private static final ExpressionParser PARSER = new SpelExpressionParser();

    public static String[] getParameterNames(ProceedingJoinPoint joinPoint) {
        Method method = IdempotentAnnotationProvider.getMethod((JoinPoint)joinPoint);
        return NAME_DISCOVERER.getParameterNames(method);
    }

    public static String[] getParameterNames(Method method) {
        return NAME_DISCOVERER.getParameterNames(method);
    }

    public static String parse(String expressionStr, EvaluationContext context) {
        Expression expression = PARSER.parseExpression(expressionStr);
        return (String)expression.getValue(context, String.class);
    }

    public static Method getMethod(JoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        if (method.getDeclaringClass().isInterface()) {
            try {
                method = joinPoint.getTarget().getClass().getDeclaredMethod(signature.getName(), method.getParameterTypes());
            }
            catch (Exception e) {
                LogUtils.error((Throwable)e);
            }
        }
        return method;
    }
}

