/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.idempotent.enhance.core.aspect;

import com.taotao.boot.common.utils.context.ContextUtils;
import com.taotao.boot.idempotent.enhance.core.annotation.Idempotent;
import com.taotao.boot.idempotent.enhance.core.aspect.IdempotentAnnotationProvider;
import com.taotao.boot.idempotent.enhance.core.helper.IdempotentHelper;
import java.lang.reflect.Method;
import org.apache.commons.lang3.ArrayUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@Aspect
public class IdempotentAspect {
    @Around(value="@annotation(idempotent)")
    public Object idempotentAround(ProceedingJoinPoint joinPoint, Idempotent idempotent) {
        String source = idempotent.source();
        String operationType = idempotent.operationType();
        String businessKey = idempotent.businessKey();
        Method method = IdempotentAnnotationProvider.getMethod((JoinPoint)joinPoint);
        Object[] paramNames = IdempotentAnnotationProvider.getParameterNames(method);
        if (ArrayUtils.isNotEmpty((Object[])paramNames)) {
            EvaluationContext context = this.buildContext((String[])paramNames, joinPoint.getArgs());
            source = IdempotentAnnotationProvider.parse(idempotent.source(), context);
            operationType = IdempotentAnnotationProvider.parse(idempotent.operationType(), context);
            businessKey = IdempotentAnnotationProvider.parse(idempotent.businessKey(), context);
        }
        IdempotentHelper idempotentHelper = (IdempotentHelper)ContextUtils.getBean(IdempotentHelper.class);
        try {
            return idempotentHelper.invoke(source, operationType, businessKey, method.getGenericReturnType(), () -> ((ProceedingJoinPoint)joinPoint).proceed());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private EvaluationContext buildContext(String[] paramNames, Object[] paramValues) {
        StandardEvaluationContext context = new StandardEvaluationContext();
        if (paramNames == null || paramValues == null) {
            return context;
        }
        for (int i = 0; i < paramValues.length; ++i) {
            context.setVariable(paramNames[i], paramValues[i]);
        }
        return context;
    }
}

