/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.idempotent.enhance.core.config;

import com.taotao.boot.idempotent.enhance.core.aspect.IdempotentAspect;
import com.taotao.boot.idempotent.enhance.core.config.properties.IdempotentCoreProperties;
import com.taotao.boot.idempotent.enhance.core.handler.DefaultIdempotentExceptionEventHandler;
import com.taotao.boot.idempotent.enhance.core.handler.IdempotentExceptionEventHandler;
import com.taotao.boot.idempotent.enhance.core.helper.IdempotentHelper;
import com.taotao.boot.idempotent.enhance.core.registry.IdempotentRepositoryRegistrySupport;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={IdempotentCoreProperties.class})
public class IdempotentCoreAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={IdempotentHelper.class})
    @ConditionalOnMissingBean(value={IdempotentAspect.class})
    public IdempotentAspect idempotentAspect() {
        return new IdempotentAspect();
    }

    @Bean
    @ConditionalOnMissingBean
    public IdempotentExceptionEventHandler defaultIdempotentExceptionEventHandler() {
        return new DefaultIdempotentExceptionEventHandler();
    }

    public IdempotentRepositoryRegistrySupport idempotentRepositoryRegistrySupport(IdempotentCoreProperties properties) {
        return new IdempotentRepositoryRegistrySupport(properties);
    }
}

