/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.idempotent.enhance.core.registry;

import com.taotao.boot.common.utils.context.ContextUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.idempotent.enhance.core.config.properties.IdempotentCoreProperties;
import com.taotao.boot.idempotent.enhance.core.exception.IdempotentException;
import com.taotao.boot.idempotent.enhance.core.registry.IdempotentRepositoryRegistry;
import com.taotao.boot.idempotent.enhance.core.repository.IdempotentRepository;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.lang.NonNull;

public class IdempotentRepositoryRegistrySupport
implements ApplicationListener<ContextRefreshedEvent> {
    private final IdempotentCoreProperties properties;

    public IdempotentRepositoryRegistrySupport(IdempotentCoreProperties properties) {
        this.properties = properties;
    }

    public void onApplicationEvent(@NonNull ContextRefreshedEvent event) {
        Map repositories;
        try {
            repositories = ContextUtils.getBeansOfType(IdempotentRepository.class);
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new RuntimeException("Can not found any IdempotentRepository implements, please check config.");
        }
        LogUtils.info((String)"The number of IdempotentRepository is [{}], register it to registry now.", (Object[])new Object[]{repositories.size()});
        boolean onlyOneRepository = repositories.size() == 1;
        repositories.forEach((beanName, repository) -> {
            LogUtils.warn((String)"=================>>>>>>>>>>>>>>>>> Register [{}] to registry begin.", (Object[])new Object[]{beanName});
            if (onlyOneRepository) {
                IdempotentRepositoryRegistry.setPrimaryRepository(repository);
            }
            IdempotentRepositoryRegistry.register(beanName, repository);
            LogUtils.warn((String)"=================>>>>>>>>>>>>>>>>> Register [{}] to registry success.", (Object[])new Object[]{beanName});
        });
        if (Objects.isNull(IdempotentRepositoryRegistry.getPrimaryRepository())) {
            String primaryRepository = this.properties.getPrimaryRepository();
            if (StringUtils.isBlank((CharSequence)primaryRepository) || Objects.isNull(IdempotentRepositoryRegistry.find(primaryRepository))) {
                throw new IdempotentException("Can not found primaryRepository, please check config.");
            }
            IdempotentRepositoryRegistry.setPrimaryRepository(IdempotentRepositoryRegistry.find(primaryRepository));
        }
        LogUtils.warn((String)"Register IdempotentRepository to registry finished, register count is [{}], primaryRepository is [{}].", (Object[])new Object[]{IdempotentRepositoryRegistry.getIdempotentRepositories().size(), IdempotentRepositoryRegistry.getPrimaryRepository().getClass().getName()});
    }
}

