/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.idempotent.enhance.redis.config;

import com.taotao.boot.idempotent.enhance.core.config.properties.IdempotentCoreProperties;
import com.taotao.boot.idempotent.enhance.core.handler.IdempotentExceptionEventHandler;
import com.taotao.boot.idempotent.enhance.core.helper.IdempotentHelper;
import com.taotao.boot.idempotent.enhance.core.repository.IdempotentRepository;
import com.taotao.boot.idempotent.enhance.redis.RedisIdempotentRepositoryImpl;
import com.taotao.boot.idempotent.enhance.redis.config.properties.IdempotentRedisAdapterProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.lang.NonNull;

@Configuration
@EnableConfigurationProperties(value={IdempotentRedisAdapterProperties.class})
public class IdempotentAdapterRedisAutoConfiguration {
    @Bean(name={"idempotentStringRedisTemplate"})
    @ConditionalOnMissingBean(name={"idempotentStringRedisTemplate"})
    public StringRedisTemplate stringRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
        StringRedisTemplate template = new StringRedisTemplate();
        template.setConnectionFactory(redisConnectionFactory);
        return template;
    }

    @Bean(name={"redisIdempotentRepository"})
    @ConditionalOnMissingBean(name={"redisIdempotentRepository"})
    public IdempotentRepository redisIdempotentRepository(@NonNull @Qualifier(value="idempotentStringRedisTemplate") StringRedisTemplate redisTemplate, @NonNull IdempotentRedisAdapterProperties properties) {
        return new RedisIdempotentRepositoryImpl(redisTemplate, properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public IdempotentHelper idempotentHelper(@NonNull IdempotentRepository idempotentRepository, @NonNull IdempotentExceptionEventHandler exceptionEventHandler, @NonNull IdempotentCoreProperties idempotentCoreProperties) {
        return new IdempotentHelper(exceptionEventHandler, idempotentRepository, idempotentCoreProperties);
    }
}

