/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.job.quartz.execution;

import com.google.common.base.Stopwatch;
import com.taotao.boot.common.utils.context.ContextUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.job.quartz.entity.QuartzTask;
import com.taotao.boot.job.quartz.entity.QuartzTaskLog;
import com.taotao.boot.job.quartz.utils.QuartzLogRecord;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobExecutionContext;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractQuartzExecutionJob
extends QuartzJobBean {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeInternal(JobExecutionContext context) {
        QuartzTask quartzTask = (QuartzTask)context.getMergedJobDataMap().get((Object)"JOB_KEY");
        QuartzTaskLog quartzTaskLog = new QuartzTaskLog();
        quartzTaskLog.setJobName(quartzTask.getJobName());
        quartzTaskLog.setBeanName(quartzTask.getBeanName());
        quartzTaskLog.setMethodName(quartzTask.getMethodName());
        quartzTaskLog.setParams(quartzTask.getParams());
        quartzTaskLog.setCronExpression(quartzTask.getCronExpression());
        quartzTaskLog.setExecutionThread(Thread.currentThread().getName());
        quartzTaskLog.setStartTime(LocalDateTime.now());
        Stopwatch sw = Stopwatch.createStarted();
        try {
            LogUtils.info((String)"\u51c6\u5907\u6267\u884c\u4efb\u52a1\uff0c\u4efb\u52a1ID\uff1a{}", (Object[])new Object[]{quartzTask.getId()});
            this.doExecute(quartzTask);
            long seconds = sw.stop().elapsed(TimeUnit.SECONDS);
            quartzTaskLog.setTime(seconds);
            quartzTaskLog.setSuccess(true);
            quartzTaskLog.setEndTime(LocalDateTime.now());
            LogUtils.info((String)"\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5\uff0c\u4efb\u52a1\u540d\u79f0\uff1a{} \u603b\u5171\u8017\u65f6\uff1a{} \u79d2", (Object[])new Object[]{quartzTask.getJobName(), seconds});
        }
        catch (Exception e) {
            LogUtils.error((String)("\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u4efb\u52a1\u540d\u79f0\uff1a{}" + quartzTask.getJobName()), (Object[])new Object[]{e});
            long seconds = sw.stop().elapsed(TimeUnit.SECONDS);
            quartzTaskLog.setTime(seconds);
            quartzTaskLog.setSuccess(false);
            quartzTaskLog.setExceptionDetail(LogUtils.getStackTrace((Throwable)e));
            quartzTaskLog.setEndTime(LocalDateTime.now());
        }
        QuartzLogRecord quartzLogService = (QuartzLogRecord)ContextUtils.getBean(QuartzLogRecord.class, (boolean)false);
        if (quartzLogService != null) {
            quartzLogService.addLog(quartzTaskLog);
        }
    }

    protected void doExecute(QuartzTask scheduleJob) throws Exception {
        String methodName = scheduleJob.getMethodName();
        String params = scheduleJob.getParams();
        Object target = ContextUtils.getBean((String)scheduleJob.getBeanName(), (boolean)true);
        if (Objects.isNull(target)) {
            throw new RuntimeException("\u672a\u627e\u5230bean");
        }
        Method method = StringUtils.isNotBlank((CharSequence)params) ? target.getClass().getDeclaredMethod(methodName, String.class) : target.getClass().getDeclaredMethod(methodName, new Class[0]);
        ReflectionUtils.makeAccessible((Method)method);
        if (StringUtils.isNotBlank((CharSequence)params)) {
            method.invoke(target, params);
        } else {
            method.invoke(target, new Object[0]);
        }
    }
}

