/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.job.quartz.listener;

import com.taotao.boot.common.utils.collection.MapUtils;
import com.taotao.boot.job.quartz.listener.AbstractJobListener;
import com.taotao.boot.job.quartz.listener.AbstractSchedulerListener;
import com.taotao.boot.job.quartz.listener.AbstractTriggerListener;
import java.util.Map;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerListener;
import org.quartz.TriggerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class QuartzListenerRegister
implements ApplicationContextAware,
InitializingBean {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ApplicationContext applicationContext;
    private Scheduler scheduler;

    public void afterPropertiesSet() throws Exception {
        this.awareSchedulerListeners();
        this.awareJobListeners();
        this.awareTriggerListeners();
    }

    private void awareSchedulerListeners() throws Exception {
        this.log.info("--------\u52a0\u8f7dSchedulerListener\u5f00\u59cb--------");
        Map schedulerListenerMap = this.applicationContext.getBeansOfType(AbstractSchedulerListener.class);
        if (MapUtils.isEmpty((Map)schedulerListenerMap)) {
            this.log.info("\u7cfb\u7edf\u672a\u6ce8\u518cSchedulerListener\uff01");
            return;
        }
        for (AbstractSchedulerListener schedulerListener : schedulerListenerMap.values()) {
            this.scheduler.getListenerManager().addSchedulerListener((SchedulerListener)schedulerListener);
        }
        this.log.info("--------\u52a0\u8f7dSchedulerListener\u7ed3\u675f--------");
    }

    private void awareJobListeners() throws Exception {
        this.log.info("--------\u52a0\u8f7dJobListener\u5f00\u59cb--------");
        Map jobListenerMap = this.applicationContext.getBeansOfType(AbstractJobListener.class);
        if (MapUtils.isEmpty((Map)jobListenerMap)) {
            this.log.info("\u7cfb\u7edf\u672a\u6ce8\u518cJobListener\uff01");
            return;
        }
        for (AbstractJobListener jobListener : jobListenerMap.values()) {
            this.scheduler.getListenerManager().addJobListener((JobListener)jobListener);
        }
        this.log.info("--------\u52a0\u8f7dJobListener\u7ed3\u675f--------");
    }

    private void awareTriggerListeners() throws Exception {
        this.log.info("--------\u52a0\u8f7dTriggerListener\u5f00\u59cb--------");
        Map triggerListenerMap = this.applicationContext.getBeansOfType(AbstractTriggerListener.class);
        if (MapUtils.isEmpty((Map)triggerListenerMap)) {
            this.log.info("\u7cfb\u7edf\u672a\u6ce8\u518cTriggerListener\uff01");
            return;
        }
        for (AbstractTriggerListener abstractTriggerListener : triggerListenerMap.values()) {
            this.log.info("--------" + abstractTriggerListener.getClass().getName());
            this.scheduler.getListenerManager().addTriggerListener((TriggerListener)abstractTriggerListener);
        }
        this.log.info("--------\u52a0\u8f7dTriggerListener\u7ed3\u675f--------");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }
}

