/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.job.quartz.other.core.aspect;

import com.taotao.boot.common.utils.context.ContextUtils;
import com.taotao.boot.job.quartz.other.core.annotation.ArtQuartzJob;
import com.taotao.boot.job.quartz.other.core.service.ArtJobLogService;
import java.time.Duration;
import java.time.LocalDateTime;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class ArtJobLogAspect {
    @Around(value="target(com.taotao.boot.job.quartz.other.core.job.ArtJob)&&args(String)")
    public Object logPointCut(ProceedingJoinPoint pjp) {
        Object o;
        LocalDateTime startTime = LocalDateTime.now();
        Class<?> clazz = pjp.getTarget().getClass();
        ArtQuartzJob quartzJob = clazz.getAnnotation(ArtQuartzJob.class);
        String beanName = quartzJob.name();
        try {
            o = pjp.proceed();
            if (quartzJob.log()) {
                LocalDateTime endTime = LocalDateTime.now();
                String msg = String.format("\u6267\u884c\u4efb\u52a1:%s,\u6267\u884c\u8017\u65f6:%d\u6beb\u79d2", beanName, Duration.between(startTime, endTime).toMillis());
                ArtJobLogService artJobLogService = (ArtJobLogService)ContextUtils.getBean(ArtJobLogService.class, (boolean)false);
                if (null != artJobLogService) {
                    artJobLogService.addJobLog(beanName, msg, null);
                }
            }
        }
        catch (Throwable e) {
            ArtJobLogService artJobLogService;
            if (quartzJob.log() && null != (artJobLogService = (ArtJobLogService)ContextUtils.getBean(ArtJobLogService.class, (boolean)false))) {
                artJobLogService.addJobLog(beanName, null, e.getLocalizedMessage());
            }
            throw new RuntimeException(e);
        }
        return o;
    }
}

